(function(Lego){
if (!Lego) Lego = window.Lego = {};

/**
 * Параметризованный счётчик клика на ссылку или просто показа.
 * Перевызывает Lego.c(w, a) из counter.js
 *
 * В случае клика подменяет href на redir'овский, потом по таймауту возвращает его обратно.
 *
 * В случае учёта показа динамически создаёт iframe с URL системы учёта.
 *
 * Пример использования:
 *
 * <a href="http://meteoinfo.ru" onclick="Lego.cp(0,1917,'weather.tabs.fotki',this)">Гидрометцентр</a>
 *
 * или
 *
 * <script type="text/javascript">Lego.cp(0,1917,'weather.tabs.fotki')</script>
 *
 * @param pi    номер проекта (pid)
 * @param ci    номер счётчика (cid)
 * @param p     parameter
 * @param a     (optional) ссылка, клик на которую надо учитывать
 */
Lego.cp = function(pi, ci, p, a) {
    Lego.c('stred/pid=' + pi + '/cid=' + ci + '/path=' + p, a);
}

})(window.Lego);
