(function(Lego){
if (!Lego) Lego = window.Lego = {};

/*
    Для работы скрипта необходимы следующие инклюды:

    sharp-js.js
    event.add.js
    event.del.js
*/ /**/

var g_dropdown, g_dropdown_timeout;

Lego.dropdown = function(e) {
    var d = document;

    var a;
    if (window.event) {
        a = e.srcElement;
        event.cancelBubble = true;
    } else {
        a = e.target;
        e.stopPropagation();
    }


    // обработчик для Esc
    var esc = function(e) {
        var e = e || event;

        if ((e.keyCode == 27) && !(e.ctrlKey || e.altKey)) {
            Lego.dropdown.cancel();
        }
    }

    // обработчик для клика
    var click = function(e) {
        var a = e ? e.target : event.srcElement;

        while (a) {
            // ничего не делам, если клик на фон popup'а
            if (a.className && (a.className.indexOf("b-dropdown") != -1)) {
                return;
            }
            a = a.parentNode;
        }

        Lego.dropdown.cancel();
    }

    // обработчик для mouseout, если мышка вышла за пределы попапа через секунду скрываем его
    var mouseout = function() {
        g_dropdown_timeout = setTimeout(Lego.dropdown.cancel, 1000);
    }

    // обработчик для mouseover, если мышка успела вернуться пока не прошла секунда не скрываем попап
    var mouseover = function() {
        clearTimeout(g_dropdown_timeout);
    }

    // убирает popup
    Lego.dropdown.cancel = function() {
        var m = g_dropdown;

        if (m) {
            Lego.delEvent(d, "click", click);
            Lego.delEvent(d, "keydown", esc);
            Lego.delEvent(m, "mouseout", mouseout);
            Lego.delEvent(m, "mouseover", mouseover);

            /* Fix for Opera 9.2x- */
            m.style.visibility = "hidden";

            var p = m.parentNode;

            // возвращаем b-dropdown на место
            p.insertBefore(m.lastChild, m);

            // удаляем распорку
            p.removeChild(m.nextSibling);

            // удаляем b-dropdown-popup
            p.removeChild(m);

            g_dropdown = 0;

            return 1;
        }

        return 0;
    }

    // если уже показан popup, скрываем его, иначе показываем
    if (!Lego.dropdown.cancel()) {
        // ищем корневой элемент dropdown'а с классом b-dropdown
        var menu = a;
        while (menu.className.indexOf("b-dropdown") == -1) {
            menu = menu.parentNode;
        }

        // в p будет родитель b-dropdown
        var p = menu.parentNode;

        // создаём b-dropdown-popup который будет спозиционирован поверх b-dropdown абсолютно
        g_dropdown = document.createElement("div");
        g_dropdown.className = "b-dropdown-popup";
        p.insertBefore(g_dropdown, menu);

        var v = navigator.userAgent;

        // первым делом подкладываем iframe, чтобы перекрывать flash
        var f = document.createElement("iframe");
        f.frameBorder = 0;

        f.src = "javascript:'<body style=\\'background:none;overflow:hidden\\'>'";

        g_dropdown.appendChild(f);

        // добавляем распорку, которая будет держать box, когда мы вынем из него b-dropdown и добавим его в b-dropdown-popup
        if ((v.match(/MSIE [56]/) || ((document.compatMode != "CSS1Compat") && v.match(/MSIE/) && !v.match(/Opera/)))) {
            // У MSIE проблемы с клонированием нода при использованиии b-icon и g-png, потому что там динамически
            // создаются expression'ом элементы. При клонированиии MSIE6- подвисает. Поэтому генерим пустой бокс
            // с размерами как у b-dropdown. Да, при увеличении размера шрифта он не будет меняться.
            var spacer = document.createElement("span");
            spacer.style.width = menu.offsetWidth + "px";
            spacer.style.height = menu.offsetHeight + "px";
            spacer.style.zoom = 1;
            p.insertBefore(spacer, menu);
        } else {
            p.insertBefore(menu.cloneNode(true), menu);
        }

        // вынимаем b-dropdown и добавляем его в b-dropdown-popup
        g_dropdown.appendChild(menu);

        // добавляем обработку события на нажатие Esc
        Lego.addEvent(d, "keydown", esc);

        // добавляем обработку события на клик
        Lego.addEvent(d, "click", click);

        // добавляем обработку события на выход мышки за меню
        Lego.addEvent(g_dropdown, "mouseout", mouseout);

        // добавляем обработку события на возврат мышки в меню
        Lego.addEvent(g_dropdown, "mouseover", mouseover);
    }

    return false;
};

})(window.Lego);
