(function($, Lego){
if (!Lego) Lego = window.Lego = {};
// Использует cookie.js и check-session.js. Без них не работает.

/**
 * Инициализирует Лего некоторыми параметрами (для вариативности в пределах разных страниц).
 *
 * @param params объект Лего-параметров, необходимые параметры инициализируются умолчательными значениями
 *        params.login логин текущего пользователя ('' для неавторизованного)
 *        params.locale двухбуквенный код локали в нижнем регистре
 *        params.id идентификатор сервиса
 *        params['show-counters-percent'] процент срабатывания счётчиков Lego.ch() (по умолчанию 100)
 *
 * @return возвращает установленные параметры с учотом умолчательных значений
 */
Lego.init = function(params) {
    params = params || {};

    params.id = params.id || '';

    params.login = params.login || (Lego.isSessionValid() ? Lego.getCookie('yandex_login') : '');
    params.login = params.login || '';

    params.locale = params.locale || 'ru';

    params['passport-host'] = params['passport-host'] || '//passport.yandex.ru';

    params['show-counters-percent'] = params['show-counters-percent'] || 100;
    params['show-counters'] = Math.round(Math.random() * 100) <= params['show-counters-percent'];

    Lego.params = params;

    return params;
};

Lego.block = {};

Lego.blockInit = function(context, blockSelector) {
    context = context || document;
    blockSelector = blockSelector || '.g-js';
    $(context).find(blockSelector).each(function(){
        var block = $(this),
            params = this.onclick ? this.onclick() : {},
            name = params.name || '',
            init = Lego.block[name];
        if (init && !block.data(name)) {
            init.call(block, params);
            block.data(name, true);
        }
    });
};

$(document).ready(function(){ Lego.blockInit() });

})(jQuery, window.Lego);
