(function(Lego){
if (!Lego) Lego = window.Lego = {};
// Использует cookie.js и check-session.js. Без них не работает.

var g_login, g_loginkeydown;

// TODO: клик вне окна логина должен закрывать его
/**
 * Показывает popup-окно входа. Не зависит от внешних стилей, все стили внутри
 * этой функции. Если тип сессии 3 (две недели), то взводится checkbox
 * "запомнить" на две недели.
 *
 * Пример вызова:
 *
 * &lt;a href="http://passport.yandex.ru/passport?mode=auth&amp;retpath=http://mail.yandex.ru/"
 *    onclick="return Lego.login(2, 'http://mail.yandex.ru/')"&gt;Войти в почту&lt;/a&gt;
 *
 * @param type      тип сессии: 0 и 2 – временная, 1 – 10 лет, 3 – две недели (см. <a href="https://wiki.yandex.ru/passport/sessionid">wiki.yandex.ru/passport/sessionid</a>)
 * @param rp        return path, URL возврата после входа
 * @param kspace    используется для кроссдоменной авторизации, например, "beta.ya.ru"
 * @param msg       если параметр msg отличен от mail по умолчанию
 *
 * @return  возвращает true, если окно не было показано, что позволяет сразу перейти по ссылке
 */
Lego.login = function(type, rp, kspace, msg) {
    if (Lego.isSessionValid()) return true;

    if (!rp) rp = location.href;

    var f = document.forms.LOGIN;
    if (!f) {
        var T = 'tabindex=1';
        var P = Lego.params['passport-host'] + '/passport?mode=';
        var PA = 'position:absolute;';
        var TD = 'font-size:11px;padding:0;vertical-align:middle';
        var IN = 'font:120% Arial,sans-serif;margin:0;vertical-align:middle';
        var F = '<iframe frameborder=0 style="position:absolute;background:#fff'+((!(navigator.userAgent.match(/MSIE [67]/) && !navigator.userAgent.match(/Opera/)) && !(navigator.platform.match(/Linux/) && !navigator.userAgent.match(/Konqueror/)))?";display:none":"")+'"></iframe>';

        var STD = ' style="' + TD + '"';

        msg = msg || 'mail';

        f = document.createElement("div");
        f.innerHTML +=
            '<div style="font-size:12px;'+PA+'z-index:9999;top:33px;left:50%;display:none;width:21.1em;margin-left:-10.5em;">'+F+F+
            '<form name=LOGIN class=login action="'+P+'auth"method=post onsubmit="this.timestamp.value=new Date().getTime()"'+
                'style="'+PA+'background:#333">'+
                '<div style="position:relative;top:-3px;left:-3px;border:1px solid #000;border-top-color:#666;border-left-color:#666;background:#fff">'+
                    '<span style="font-family:Verdana,sans-serif;font-size:85%;'+PA+'padding:0.05em 0.55em 0.25em;color:#f8d471;background:#900">&#1087;&#1072;&#1089;&#1087;&#1086;&#1088;&#1090;</span>'+

                    '<table cellspacing=5 style="width:100%;margin-top:17px;border-spacing:5px;border-collapse:separate;border:15px solid #fff;color:#000">'+
                    '<tr>'+
                        '<td>'+
                        '<td style="'+TD+';width:99%;padding-bottom:10px"><a '+T+' style="color:#666"href="'+P+'register&amp;msg='+msg+'&amp;retpath='+rp+'">&#1047;&#1072;&#1088;&#1077;&#1075;&#1080;&#1089;&#1090;&#1088;&#1080;&#1088;&#1086;&#1074;&#1072;&#1090;&#1100;&#1089;&#1103;</a>'+
                    '<tr>'+
                        '<td'+STD+'>&#1051;&#1086;&#1075;&#1080;&#1085;:'+
                        '<td'+STD+'><input name=login style="width:99%;'+IN+'"'+T+'>'+
                    '<tr>'+
                        '<td'+STD+'>&#1055;&#1072;&#1088;&#1086;&#1083;&#1100;:'+
                        '<td'+STD+'><input name=passwd type=password style="width:99%;'+IN+'"'+T+'>'+
                    '<tr>'+
                        '<td>'+
                        '<td'+STD+'>'+
                            '<input id=z name=twoweeks '+T+' type=checkbox value=yes style="'+IN+'"> '+
                            '<label for=z>&#1079;&#1072;&#1087;&#1086;&#1084;&#1085;&#1080;&#1090;&#1100; &#1084;&#1077;&#1085;&#1103;</label> '+
                            '<a style="margin-left:4px"tabindex=3 href="http://help.yandex.ru/passport/?id=922493"target=help><img src="//img.yandex.net/i/i-help2.gif"width=10 height=10 border=0 alt="[?]"></a>'+

                            '<div style="padding-top:.9em">'+
                                '<input type=hidden name=retpath value="' + rp + '">'+
                                '<input type=hidden name=timestamp>'+
                                (kspace ? '<input type=hidden name=kspace>' : "") +
                                '<input style="'+IN+';margin-right:9px"type=submit '+T+' value="&#1042;&#1086;&#1081;&#1090;&#1080;"><input type=button style="'+IN+'"'+T+' onclick="Lego.loginHide()"value="&#1047;&#1072;&#1082;&#1088;&#1099;&#1090;&#1100;">'+
                                '<div style="margin-top:1.4em"><a tabindex=2 style="color:#666"href="'+P+'remember&amp;msg='+msg+'&amp;retpath='+rp+'">&#1047;&#1072;&#1073;&#1099;&#1083;&#1080; &#1087;&#1072;&#1088;&#1086;&#1083;&#1100;?</a></div>'+
                            '</div>'+
                    '</table>'+
                '</div>'+
            '</form>';

        document.body.appendChild(f);
        f = document.forms.LOGIN;
    }

    // запоминаем старый onkeydown
    g_loginkeydown = document.onkeydown;

    // и навешиваем новый, который будет закрывать окно по нажатию на Esc
    document.onkeydown = function (e) {
        e = e || window.event;

        if ((e.keyCode == 27) && (!e.ctrlKey) && (!e.altKey)) {
            Lego.loginHide();
        }
    }

    // TODO: непонятно, что это такое и зачем надо
    if (type == 2) {
        var login = getCookie('yandex_login');
        type = (login && login.length > 1);
        if (type) {
            if (f.login.value != login) {
                f.login.value = login;
                f.passwd.value = '';
                type = -1;
            }
        }
    }

    f.twoweeks.checked = (type == 3);

    if (kspace) f.kspace.value = kspace;

    f.parentNode.style.display = 'block';
    var f1 = f.previousSibling;
    var f2 = f1.previousSibling;
    f1.style.width = f2.style.width = f.scrollWidth + "px";
    f1.style.height = f2.style.height = f.scrollHeight + "px";
    f2.style.margin = "-3px 0 0 -3px";

    // NOTE: если выставили имя в поле login (см. выше), то устанавливаем фокус на пароль
    setTimeout('document.forms.LOGIN.' + (type != -1 ? "login" : "passwd") + '.focus()', 1);

    g_login = f;

    return false;
}

/**
 * Скрывает окно входа и восстанавливает старый onkeydown.
 */
Lego.loginHide = function() {
    document.onkeydown = g_loginkeydown;
    var f = g_login.parentNode;
    f.style.display = "none";
    g_login.login.value = g_login.passwd.value = '';
    g_login = null;
}
})(window.Lego);
