(function(Lego){
if (!Lego) Lego = window.Lego = {};

/**
 * Подставляет пример в поле поиска и добавляет скрытое поле nl со значением 1.
 *
 * Примеры использования:
 *
 * <a class="b-pseudo-link" href="" onclick="return Lego.sample(this)"><span>...</span></a>
 * <a class="b-pseudo-link" href="" onclick="return Lego.sample(this,{name:'who'})"><span>...</span></a>
 * <a class="b-pseudo-link" href="" onclick="return Lego.sample(this,{nl:1})"><span>...</span></a>
 *
 * @param   a   элемент с примером, откуда берётся текст
 * @param   p   параметры (optional)
 *              name   имя поля для подстановки примера, если не указан "text"
 *              nl     cоздавать ли параметр nl=1, если не указан не создавать
 *
 */
Lego.sample = function(a, p) {
    var name = (p && p.name) || "text";

    var f = document.getElementById("b-head-search");

    // STRANGE: MSIE: проверка !f.nl не работает, если нажать пример два раза будет создан nl=1 дважды
    if (p && p.nl && !f.nl) {
        var z = document.createElement("input");
        z.name = "nl";
        z.type = "hidden";
        z.value = 1;
        f.appendChild(z);
    }

    f[name].value = (a.innerText ? a.innerText : a.innerHTML.replace(new RegExp("<.*?>", "g"), '').replace(/&nbsp;/g, " ")).replace(/&amp;/g, '&').replace(/&quot;/g, '"');
    f[name].focus();

    return false;
}

})(window.Lego);