(function(Lego){
if (!Lego) Lego = window.Lego = {};

/**
 * Модификация tabs.js для внутренних сервисов
 */
Lego.tabs = function() {
    if (document.getElementById && (typeof(encodeURIComponent) == 'function')) {
        var tabs = document.getElementById("tabs");

        if (tabs) {
            var f = document.getElementById("b-head-search");
            tabs = tabs.getElementsByTagName("a");

            /*
                Заводим эту переменную здесь, а не в цикле, потому что при разворачивании
                списка-за-ещё увеличивается количество ссылок, а getElementsByTagName возвращает
                не обычный, а динамический массив, который обновляется при этом и у нас резко
                становится больше элементов.
            */
            var l = tabs.length - 1;

            var advanced = document.getElementById("advanced");
            var advHref;
            if (advanced) {
                advHref = advanced.href;
                advHref = advHref.replace(/([?&])text=[^&]*/g, '$1');
                advHref += advHref.indexOf('?') == -1 ? '?' : '&';
            }

            setInterval(function() {
                var t = "";
                for (var i = 0; i < f.length; i++) {
                    if (f[i].type == "text") {
                        t = f[i].value.replace(/^\s+|\s+$/g, "");
                        break;
                    }
                }

                if (advanced) {
                    advanced.href = advHref + (t != '' ? 'text=' + encodeURIComponent(t) : '');
                }

                for (var i = 0; i < l; i++) {
                    var url = "";
                    var a = tabs[i];

                    var h = a.host.split(".")[0];

                    if (h == "clck") {
                        continue;
                    }

                    if (t != "") {
                        if (h == "wiki") {
                            url = "search?text=";
                        } else if (h == "staff") {
                            url = "staff/result.xhtml?name=";
                        } else if (h == "jira") {
                            url = "secure/QuickSearch.jspa?searchString=";
                        } else if ((h == "ml") || (h == "maillists")) {
                            url = "archive/search/?query=";
                        } else {
                            continue;
                        }

                        url += encodeURIComponent(t);
                    }

                    var tmp = a.protocol + '//' + a.host + '/' + url;
                    if ((a.parentNode.tagName.toLowerCase() != "strong") && (a.href != tmp)) {
                        a.href = tmp;
                    }
                }
            }, 200);
        }
    }
}

})(window.Lego);