(function(Lego){
if (!Lego) Lego = window.Lego = {};

/**
 * Позволяет передать набраный пользователем запрос в другой таб. Для этого
 * 5 раз в секунду опрашивается поле ввода и введённый в него текст
 * подставляется в ссылки у табов.
 *
 * (опционально) Осуществляет проброс запроса в расширенный поиск. Для этого должна быть ссылка с id="advanced".
 *
 * Пример использования:
 *
 *  <table id="tabs" class="b-head-tabs">
 *  <tr>
 *      <td><strong>Поиск</strong></td>
 *      <td><a href="http://mail.yandex.ru">Почта</a></td>
 *      <td><a href="http://news.yandex.ru">Новости</a></td>
 *      <td><a href="http://market.yandex.ru">Маркет</a></td>
 *      <td><a href="http://maps.yandex.ru">Карты</a></td>
 *      <td><a href="http://slovari.yandex.ru">Словари</a></td>
 *      <td><a href="http://images.yandex.ru">Картинки</a></td>
 *      <td><a href="http://video.yandex.ru">Видео</a></td>
 *      <td class="more">
 *          <div class="b-dropdown">
 *              <ul>
 *                  <li class="visible">
 *                      <a class="or" href="" onclick="return Lego.dropdown(event)"
 *                          ><span class="b-pseudo-link"><span>ещё</span></span
 *                          ><i class="arrow"><i class="b-icon"><i></i></i></i></a>
 *                  </li>
 *                  <li><a href="http://auto.yandex.ru">Авто</a></li>
 *                  <li><a href="http://adresa.yandex.ru">Адреса</a></li>
 *                  <li><a href="http://afisha.yandex.ru">Афиша</a></li>
 *                  <li><a href="http://blogs.yandex.ru">Блоги</a></li>
 *                  <li><a href="http://money.yandex.ru">Деньги</a></li>
 *                  <li><a href="http://play.yandex.ru">Игрушки</a></li>
 *                  <li><a href="http://yaca.yandex.ru">Каталог</a></li>
 *                  <li><a href="http://moikrug.yandex.ru">Мой Круг</a></li>
 *                  <li><a href="http://narod.yandex.ru">Народ</a></li>
 *                  <li><a href="http://cards.yandex.ru">Открытки</a></li>
 *                  <li><a href="http://weather.yandex.ru">Погода</a></li>
 *                  <li><a href="http://probki.yandex.ru">Пробки</a></li>
 *                  <li><a href="http://rasp.yandex.ru">Расписания</a></li>
 *                  <li><a href="http://tv.yandex.ru">Телепрограмма</a></li>
 *                  <li><a href="http://fotki.yandex.ru">Фотки</a></li>
 *                  <li class="line"><a href="http://www.yandex.ru/all">Все&nbsp;сервисы</a></li>
 *              </ul>
 *          </div>
 *      </td>
 *  </tr>
 *  </table>
 *  <script type="text/javascript">Lego.tabs("market")</script>
 */
var clids = {};
Lego.tabs = function(service) {
    if (document.getElementById && (typeof(encodeURIComponent) == 'function')) {
        var tabs = document.getElementById("tabs");

        if (tabs) {
            var f = document.getElementById("b-head-search");
            tabs = tabs.getElementsByTagName("a");

            /*
                Заводим эту переменную здесь, а не в цикле, потому что при разворачивании
                списка-за-ещё увеличивается количество ссылок, а getElementsByTagName возвращает
                не обычный, а динамический массив, который обновляется при этом и у нас резко
                становится больше элементов.
            */
            var l = tabs.length - 1;

            var advanced = document.getElementById("advanced");
            var advHref;
            if (advanced) {
                advHref = advanced.href;
                advHref = advHref.replace(/([?&])text=[^&]*/g, '$1');
                advHref += advHref.indexOf('?') == -1 ? '?' : '&';
            }

            var marketClid = 527;
            switch (service) {
                case "www":     marketClid = 505; break;
                case "search":  marketClid = 521; break;
                case "images":  marketClid = 526; break;
            }

            setInterval(function() {
                var t = "";
                for (var i = 0; i < f.length; i++) {
                    if (f[i].type == "text") {
                        t = f[i].value.replace(/^\s+|\s+$/g, "");
                        break;
                    }
                }

                if (advanced) {
                    advanced.href = advHref + (t != '' ? 'text=' + encodeURIComponent(t) : '');
                }

                for (var i = 0; i < l; i++) {
                    var url = "";
                    var a = tabs[i];

                    var h = a.host.split(".")[0];

                    if (h == "clck" || a.className.match(/or|b-pseudo-link/)) {
                        continue;
                    }

                    if (t != "") {
                        if ((h == "www") || (h == "images")) {
                            url = "yandsearch?";
                        } else if (h == "news") {
                            url = "yandsearch?rpt=nnews&grhow=clutop&";
                        } else if (h == "yaca") {
                            url = "yandsearch?rpt=rs2&";
                        } else if (h == "market") {
                            url = "search.xml?clid=" + marketClid + "&cvredirect=1&";
                        } else if (h == "blogs") {
                            url = "search.xml?ft=blog&";
                        } else if (h == "maps") {
                            url = "?";
                        } else if ((h == "auto") ||
                                   (h == "adresa") ||
                                   (h == "video") ||
                                   (h == "slovari")) {
                            url = "search.xml?";
                        } else {
                            continue;
                        }

                        url += "text=" + encodeURIComponent(t);
                    } else if (h == "market") {
                        url = "?clid=" + marketClid + "&cvredirect=1&";
                    }

                    var clid = clids[h] || (clids[h] = (a.search.match(/[&?]clid=(\d+)/) || [])[1]);
                    if (clid && h != 'market' && !(h == 'www' && t == '')) {
                        url += (url.indexOf('?') != -1 ? '&' : '?') + 'clid=' + clid;
                    }

                    var tmp = a.protocol + '//' + a.host + '/' + url;
                    if ((a.parentNode.tagName.toLowerCase() != "strong") && (a.href != tmp)) {
                        a.href = tmp;
                    }
                }
            }, 200);
        }
    }
}

})(window.Lego);
