#!/usr/bin/env python

import os
import sys

from verba.apply import apply_pack


if __name__ == '__main__':

    service = 'bannerstorage-premoderation'

    FILE = r'/usr/lib/yandex/{0}-verba/{0}-pack.vmp'.format(service)
    if not os.path.exists(FILE):
        sys.exit('Verba pack file "{}" was not found. Put the file and rerun script.'.format(FILE))

    username = os.environ['DEPLOY_JDBC_USERNAME']
    password = os.environ['DEPLOY_JDBC_PASSWORD']
    url = os.environ['JDBC_URL'].replace('jdbc:jtds:sqlserver://', '')

    DATABASE_URL = 'mssql+pymssql://{username}:{password}@{url}'.format(username=username, password=password, url=url)

    apply_pack(FILE, DATABASE_URL)
