#!/usr/bin/env bash

set -e

VERSION=$1
BUILD_DIR=$2

# Install prerequisites
apt-get install -y python-verba python-verba-tools

# Make output dir
mkdir -p ${BUILD_DIR}

cd db

# Prepare meta-versioned.yml
sed -e "s/\${version}/${VERSION}/" meta.yml > meta-versioned.generated.yml

# Run sort and compile pack
verba-expand-pack --meta meta-versioned.generated.yml --dest meta-expanded.generated.yml
sort_bs_pack --meta meta-expanded.generated.yml --dest meta-sorted.generated.yml
verba-compile --metadata=meta-sorted.generated.yml --dest=${BUILD_DIR}/verba-pack.vmp --comment "Built verba"

cd ..
