SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_creative_document]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_creative_document]
GO

/*
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_creative_document]') AND type in (N'P', N'PC'))
 drop procedure sp_creative_document
*/


CREATE PROCEDURE [dbo].[sp_creative_document]

	@mode varchar(50) = null,
 
	@id uniqueidentifier = null,
	@creative_nmb int = null,
	@document_id uniqueidentifier = null
 
AS

	-----------------------------------------------------------------------------------------------------------
	-- create
	-- sp_creative_document 'create', @creative_nmb = 55390, @document_id = 'D28853DE-43FF-4BB7-8CD3-DBB5456F2CA4' 
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'create')
	begin
		select @id = id 
		from t_creative_document
		where creative_nmb = @creative_nmb
		and document_id = @document_id
		
		if(@id is null)
		begin
			select @id = newid()

			insert into t_creative_document (id, creative_nmb, document_id)
			select @id, nmb, @document_id
			from t_creative
			where nmb = @creative_nmb
		end

		select @id id
		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- delete
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'delete')
	begin
		delete from t_creative_document
		where creative_nmb = @creative_nmb
		and document_id = @document_id
		
		return
	end

	
/*
grant execute on [sp_creative_document] to admin_zone_role
*/
GO
GRANT EXECUTE ON [dbo].[sp_creative_document] TO [admin_zone_role]
GO