IF object_id('dbo.sp_creative_moderate_') IS NULL
    EXEC ('create procedure dbo.sp_creative_moderate_ as begin return end')
GO
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
GO
/*
exec sp_creative_moderate_ @creative_version_nmb = 38813,
@user_id = '8F071C78-929A-4546-8CCD-708DA175B820',
@res_status_nmb = 2, @moderation_info = '123', @reasons = '0=20;101=56;101=118;'

статусы:
2 -> 2 неотмодерирован -> сохранить результаты модерации
2 -> 3 неотмодерирован -> отклонен
2 -> 4 неотмодерирован -> принят

3 -> 2 отклонен -> неотмодерирован (на перемодерацию)
4 -> 2 принят -> неотмодерирован (на перемодерацию)
3 -> 4 отклонен -> принят (перемодерировать и принять)
*/

/*
    sp_creative_moderate_ @creative_version_nmb = 1067894,
    @user_id = 'CA09535E-4AE4-4A46-A311-94998B023E89',
    @res_status_nmb = 4,
    @moderation_info = '',
    @reasons = ''
*/

ALTER PROCEDURE [dbo].[sp_creative_moderate_]
        @creative_nmb int = null,
        @creative_version_nmb int = null,
        @user_id uniqueidentifier,
        @res_status_nmb int = null,
        @moderation_info nvarchar(max) = null,
        @reasons varchar(max) = null,
        @reject_document_reasons nvarchar(max) = null,
        @send_email_to_ccd varchar(10) = null,
        @ok int OUTPUT,
        @res varchar(200) OUT
AS
    BEGIN

        if((select count(*)
                from vs_user u
                    join vs_user_role ur on u.id = [user_id] and u.archive = 0 and ur.archive = 0
                    join vs_role r on r.id = [role_id] and symbol in ('main_moder', 'moder')
                                                        and u.id = @user_id) = 0)
            begin
                select @ok = 0, @res = 'У пользователя нет прав модератора'
                return
            end

        declare @expire_date datetime

        if(@creative_version_nmb is null)
            select @creative_version_nmb = nmb from vt_creative_version where is_last_version = 1 and creative_nmb = @creative_nmb

        declare @s varchar(max), @macros_nmb varchar(4000), @reason varchar(4000), @i int, @reason_id uniqueidentifier, @put_creatives_to_rtb int
        declare @is_ready_to_moderation bit
        declare @errorMsg AS nvarchar(max), @errorSeverity AS int, @errorState AS int
        declare @ccd_email varchar(1000), @subject varchar(1000), @body varchar(1000)
        declare @is_moderated_externally bit
        select @ccd_email = value from s_value where name = 'ccd_email'

        -- если хотят отправить почту, проверка, можно ли - установлена ли данная настройка
        if(@send_email_to_ccd = 1)
            select @send_email_to_ccd = value from s_value where name = 'send_email_to_ccd_after_lock_creative'

        declare @status_nmb int, @lock_user_id uniqueidentifier, @is_deployed bit, @is_need_remoderation bit
        set @lock_user_id = null

        create table #sp_creative_reasons (id uniqueidentifier)

        select
            @creative_nmb = cv.creative_nmb,
            @status_nmb = cv.status_nmb,
            @lock_user_id = cv.[user_id],
            @expire_date = cv.expire_date,
            @is_deployed = cv.is_deployed,
            @put_creatives_to_rtb = t.put_creatives_to_rtb,
            @is_ready_to_moderation = cv.is_ready_to_moderation,
            @is_moderated_externally = c.is_moderated_externally
        from vt_creative_version cv
            join t_creative c (nolock) on c.nmb = cv.creative_nmb
            join t_template_version t on cv.template_version_nmb = t.nmb
        where cv.nmb = @creative_version_nmb

        set @is_need_remoderation = case when @res_status_nmb = 2 and @status_nmb = 4 then 1 else 0 end;
        -----------------------------------------------------------------------------------------------------------
        -- проверки
        -----------------------------------------------------------------------------------------------------------
        if (@is_ready_to_moderation = 0)
            begin
                select @ok = 0, @res = 'Креатив не готов для модерации'
                return
            end

        if (@is_moderated_externally = 1)
            begin
                select @ok = 0, @res = 'Креатив должен модерироваться внешней системой'
                return
            end

        if(@expire_date < getdate() and @res_status_nmb <> 3)
            begin
                select @ok = 0, @res = 'Креатив устарел'
                return
            end

        /*
    2 -> 2 неотмодерирован -> сохранить результаты модерации
    2 -> 3 неотмодерирован -> отклонен
    2 -> 4 неотмодерирован -> принят

    3 -> 2 отклонен -> неотмодерирован (на перемодерацию)
    4 -> 2 принят -> неотмодерирован (на перемодерацию)
    3 -> 4 отклонен -> принят (перемодерировать и принять)
    */

        if( not(@status_nmb = 2 or ((@status_nmb = 3 or @status_nmb = 4) and @res_status_nmb in (2, 4))) )
            begin
                select @ok = 0, @res = 'Креатив не находится в статусе неотмодерирован'
                return
            end

        if(@lock_user_id <> @user_id and @status_nmb = 2)
            begin
                select @ok = 0, @res = 'Креатив заблокирован другим модератором'
                return
            end

        set xact_abort, nocount on
        BEGIN TRAN

                delete from r_creative_version_reason where creative_version_nmb = @creative_version_nmb

                ------------------------------------------------------------------------------------
                -- сохранение причин отклонения
                ------------------------------------------------------------------------------------
                select @i = charindex(';', @reasons)
                while(@i > 0)
                    begin
                        select @s = substring(@reasons, 0, @i)
                        select @macros_nmb = substring(@s, 0, charindex('=', @s)),
                                     @reason = substring(@s, charindex('=', @s) + 1, len(@s))

                        if(@macros_nmb = 0) set @macros_nmb = null

                        select @creative_version_nmb, r.id, @macros_nmb
                        from vd_reason r
                        where nmb = @reason

                        insert into r_creative_version_reason (creative_version_nmb, reason_id, macros_nmb)
                            select @creative_version_nmb, r.id, @macros_nmb
                            from vd_reason r
                            where nmb = @reason

                        select @reasons = substring(@reasons, @i + 1, len(@reasons))
                        select @i = charindex(';', @reasons)
                    end

                ------------------------------------------------------------------------------------
                -- сохранение причин отклонения для документов
                ------------------------------------------------------------------------------------
                if @reject_document_reasons is not null
                    begin
                        select @i = charindex(';', @reject_document_reasons)
                        while(@i > 0)
                            begin
                                select @s = substring(@reject_document_reasons, 0, @i)
                                select @macros_nmb = substring(@s, 0, charindex('|', @s)),
                                             @reason = substring(@s, charindex('|', @s) + 1, len(@s))

                                if(@macros_nmb = 0) set @macros_nmb = null

                                select @creative_version_nmb, r.id, @macros_nmb
                                from vd_reason r
                                where nmb = @reason

                                insert into r_creative_version_reason (creative_version_nmb, reason_id, macros_nmb)
                                    select @creative_version_nmb, r.id, @macros_nmb
                                    from vd_reason r
                                    where nmb = @reason

                                select @reject_document_reasons = substring(@reject_document_reasons, @i + 1, len(@reject_document_reasons))
                                select @i = charindex(';', @reject_document_reasons)
                            end
                    END
                ------------------------------------------------------------------------------------
                -- апдейт статуса и комментария
                ------------------------------------------------------------------------------------

                update t_creative_version
                set user_id = @user_id,
                    moderation_info = @moderation_info,
                    status_nmb =
                        case
                                when @is_need_remoderation = 1 then 3
                                else @res_status_nmb
                        end,
                    moderation_date = GETDATE(),
                    notified = 0,
                    is_enabled =
                        case
                                when @res_status_nmb = 2 then is_enabled
                                else case when @res_status_nmb = 3 then 0 else 1 end
                        end
                where nmb = @creative_version_nmb

                -- принимают
                if (@res_status_nmb = 4) begin

                        exec dbo.sp_file_update_cdn_targets @creative_version_nmb;
                        -- См. BANNERSTORAGE-1809
                        if (@is_deployed = 1)
                            exec dbo.sp_update_deployment_status_service_notify_creative_updated @creative_version_nmb;

                -- отклоняют креатив или отправляют на перемодерацию из статуса ПРИНЯТ
                end else if (@res_status_nmb = 3 or @is_need_remoderation = 1)
                    begin
                        -- Если предыдущая версия была принята и была отправлена в хост,
                        -- то отправляем уведомление об отклонении в хост (см. BANNERSTORAGE-3714)
                        -- Иначе было бы странным отправлять уведомление в хост
                        declare @isPrevVersionSentToRtb bit = (
                            case when exists(
                                    select *
                                    from (
                                                 select top(1) *
                                                 from dbo.t_creative_version
                                                 where creative_nmb = @creative_nmb
                                                             and nmb < @creative_version_nmb
                                                             and status_nmb in (3, 4)
                                                 order by nmb desc) as t
                                    where status_nmb = 4 and put_to_rtb = 1) then 1
                            else 0
                            end
                        );

                        if (@isPrevVersionSentToRtb = 1)
                        begin
                        -- Отправить уведомление о том, что креатив отклонен в хост
                            exec dbo.sp_rtbhostlink_notify_creative_changed @creative_version_nmb;
                        end;

                        -- Отправить уведомление о том, что креатив отклонен customer-у (См. BANNERSTORAGE-2036)
                        exec dbo.sp_notify_creative_customer_service_notify_creative_changed @creative_version_nmb;
                    end;

                ------------------------------------------------------------------------------------
                -- финальный апдейт статуса для кейса из статуса принят в статус ожидает модерации.
                -- см. BANNERSTORAGE-4378
                ------------------------------------------------------------------------------------

                if (@is_need_remoderation = 1)
                begin
          update t_creative_version
          set user_id = @user_id,
            moderation_info = @moderation_info,
            status_nmb = 2,
            moderation_date = GETDATE(),
            notified = 0,
            is_enabled = is_enabled
          where nmb = @creative_version_nmb
                end;

        COMMIT TRAN;

        ------------------------------------------------------------------------------------
        -- письмо ccd после сохранения предварительных результатов
        ------------------------------------------------------------------------------------
        if(@status_nmb = 2 and @res_status_nmb = 2)
            begin
                select @subject = 'Сохранены результаты модерации. ' + full_name + ', ' + cast(@creative_nmb as varchar(100))
                from dbo.s_user
                where id = @user_id

                SELECT @body = 'https://premoderation.mediaselling.yandex.net/creative/index.jsp?nmb=' + cast(@creative_version_nmb AS VARCHAR(100))

                if(@send_email_to_ccd = '1')
                    exec msdb.dbo.sp_send_dbmail
                            @recipients = @ccd_email,
                            @body             = @body,
                            @subject         = @subject
            end

        select @ok = 1, @res = 'Креатив обработан'

        return
    END
/*
grant execute on sp_creative_moderate_ to admin_zone_role
*/
GO