SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_document]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_document]
GO

/*
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_document]') AND type in (N'P', N'PC'))
 drop procedure sp_document
*/

-- select * from vt_document
-- sp_document 'create', @document_type_id = '3C877CB1-4836-4587-8900-4BB25D30CA0A', @name = 'test', @description = 'test'
-- sp_document 'select_all', @num1 = 1, @num2 = 5, @domaine = 'smecta.info', @creative_nmb = 104536, @creative_OR_domaine = 1

CREATE PROCEDURE [dbo].[sp_document]

	@mode varchar(50) = 'select_all',
 
	@id uniqueidentifier = null,
	@document_type_id uniqueidentifier = null,
	@name [varchar](500) = null,
	@description varchar(max) = null,
	@expiration_date [datetime] = null,
	@archive [tinyint] = null,
	@user_id [uniqueidentifier] = null,
	@user_change_date [datetime] = null,
	
	@expired int = 0,
	
	@creative_version_nmb int = null,
	@creative_nmb int = null,
	@file_instance_nmbs varchar(max) = null,  -- список файлов-доков которые нужно сохранить для креатива
	@creatives varchar(max) = null,
	
	@domaine_nmb int = null,
	@domaine varchar(250) = null,
	@domaines varchar(max) = null,
	
	@creative_OR_domaine int = null, 
	
	@num1 int = null,
	@num2 int = null

AS

	declare @creative varchar(10), @i int, @tomorrow datetime, @default datetime
	set @tomorrow = cast(convert(varchar(10), getdate(), 21) as datetime) + 1
	set @default = @tomorrow + 10

	CREATE TABLE #t_select_all
	(
		num int identity(1, 1),
		[id] [uniqueidentifier],
		[document_type_id] [uniqueidentifier],
		[document_type_name] [varchar](500),
		[eng_document_type_name] [varchar](500),
		[name] [varchar](500),
		[description] [varchar](max),
		[expiration_date] varchar(10),
		[user_id] [uniqueidentifier],
		[full_name] [varchar](500),
		user_change_date datetime
	)

	-----------------------------------------------------------------------------------------------------------
	-- select_for_creative
	-- sp_document 'select_for_creative', @creative_version_nmb = 56947
	-- sp_document 'select_for_creative', @creative_version_nmb = 1064952
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select_for_creative')
	begin
		select d.id,
		t.name [document_type_name], t.eng_name [eng_document_type_name],
		d.name, d.description, isnull(convert(varchar(10), [expiration_date], 21), 'нет') [expiration_date],
		case when isnull(expiration_date, GETDATE()) > GETDATE() - 1
			then 0
			else 1
		end expire
		into #select_for_creative
		from vt_document d
		join c_document_type t on document_type_id = t.id
		join t_creative_document cd on cd.document_id = d.id
		join vt_creative_version v on v.creative_nmb = cd.creative_nmb
		where v.nmb = @creative_version_nmb
		
		insert into #select_for_creative	
		select d.id, 
		t.name, t.eng_name [eng_document_type_name],  
		d.name, d.description, isnull(convert(varchar(10), [expiration_date], 21), 'нет') [expiration_date],
		case when isnull(expiration_date, GETDATE()) > GETDATE() - 1 
			then 0 
			else 1 
		end expire
		from vt_document d
		join c_document_type t on document_type_id = t.id
		join t_document_domaine dd on dd.document_id = d.id
		join t_domaine dm on domaine_nmb = dm.nmb
		join vt_creative_version_parameter on dbo.clr_uf_BeautifyUrl(value) like '%"url":%' + dm.name + '%'
		and parameter_name = 'MOBILE_ACTION_LIST' 
		where creative_version_nmb = @creative_version_nmb

		select dbo.clr_uf_BeautifyUrl(url) url
		into #urls
		from vt_creative_version_url
		where creative_version_nmb = @creative_version_nmb

		select
		/* get just the host name from a url */
		substring(url,
				/* starting position (after any '//') */
				(case when charindex('//', url)= 0 then 1 else charindex('//', url) + 2 end),
				/* length (ending on first '/' or on a '?') */
				case
				when charindex('/', url, charindex('//', url) + 2) > 0 then charindex('/', url, charindex('//', url) + 2) - (case when charindex('//', url)= 0 then 1 else charindex('//', url) + 2 end)
				when charindex('?', url, charindex('//', url) + 2) > 0 then charindex('?', url, charindex('//', url) + 2) - (case when charindex('//', url)= 0 then 1 else charindex('//', url) + 2 end)
				else len(url)
				end
		) as 'url'
		into #domains
		from #urls

		insert into #select_for_creative
		select d.id, 
		t.name, t.eng_name [eng_document_type_name],  
		d.name, d.description, isnull(convert(varchar(10), [expiration_date], 21), 'нет') [expiration_date],
		case when isnull(expiration_date, GETDATE()) > GETDATE() - 1 
			then 0 
			else 1 
		end expire
		from vt_document d
		join c_document_type t on document_type_id = t.id
		join t_document_domaine dd on dd.document_id = d.id
		join t_domaine dm on domaine_nmb = dm.nmb
		join #domains on url = 'www.' + dm.name or url like dm.name
				
		select distinct * from #select_for_creative order by expire, document_type_name
		
		return
	end
	-----------------------------------------------------------------------------------------------------------
	-- select_all
	-- sp_document 'select_all', @num1 = 1, @num2 = 25, @expired = 0
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select_all')
	begin
		if(@creative_OR_domaine = 1)
		begin
			insert into #t_select_all
			(
			[id],
			[document_type_id],
			[document_type_name],
			[eng_document_type_name],
			[name],
			[description],
			[expiration_date],
			[user_id],
			[full_name],
			user_change_date
			)
			select distinct
			d.[id],
			[document_type_id],
			t.name [document_type_name],
			t.[eng_name] [eng_document_type_name],
			d.[name],
			[description],
			isnull(convert(varchar(10), [expiration_date], 21), 'нет') [expiration_date],
			u.id,
			isnull(u.full_name, ''),
			user_change_date
			from vt_document d
			join c_document_type t on document_type_id = t.id
			left join t_creative_document cd on cd.document_id = d.id
			left join t_document_domaine dd on dd.document_id = d.id
			left join t_domaine dm on domaine_nmb = dm.nmb
			left join s_user u on [user_id] = u.id
			where 
			t.id = isnull(@document_type_id, t.id)
			and 
			(
				isnull(dm.name, '') like '%' + isnull(@domaine, isnull(dm.name, '')) + '%'
				or isnull(cd.creative_nmb, 0) = isnull(@creative_nmb, isnull(cd.creative_nmb, 0))
			)
			and [description] like ('%' + isnull(@description, '%') + '%')
			
	/*
			0 активные expiration_date <= expiration_date + 1 | expiration_date > getdate() - 1
			1 архивные expiration_date <= getdate() - 1 | expiration_date > '1900-01-01'
			2 все      expiration_date <= expiration_date + 1 | expiration_date > '1900-01-01'
	*/
			and isnull(expiration_date, @default) <= case when @expired = 1 then getdate() - 1 else isnull(expiration_date, @default) + 1 end
			and isnull(expiration_date, @default) >  case when @expired = 0 then getdate() - 1 else '1900-01-01' end
			
			and d.archive = 0
			order by user_change_date desc
		end
		else /* @creative_OR_domaine <> 1 */
		begin
			insert into #t_select_all
			(
			[id],
			[document_type_id],
			[document_type_name],
			[eng_document_type_name],
			[name],
			[description],
			[expiration_date],
			[user_id],
			[full_name],
			user_change_date
			)
			select distinct
			d.[id],
			[document_type_id],
			t.name [document_type_name],
			t.[eng_name] [eng_document_type_name],
			d.[name],
			[description],
			isnull(convert(varchar(10), [expiration_date], 21), 'нет') [expiration_date],
			u.id,
			isnull(u.full_name, ''),
			user_change_date
			from vt_document d
			join c_document_type t on document_type_id = t.id
			left join t_creative_document cd on cd.document_id = d.id
			left join t_document_domaine dd on dd.document_id = d.id
			left join t_domaine dm on domaine_nmb = dm.nmb
			left join s_user u on [user_id] = u.id
			where 
			t.id = isnull(@document_type_id, t.id)
			and isnull(dm.name, '') like '%' + isnull(@domaine, isnull(dm.name, '')) + '%'
			and isnull(cd.creative_nmb, 0) = isnull(@creative_nmb, isnull(cd.creative_nmb, 0))
			and [description] like ('%' + isnull(@description, '%') + '%')
			
	/*
			0 активные expiration_date <= expiration_date + 1 | expiration_date > getdate() - 1
			1 архивные expiration_date <= getdate() - 1 | expiration_date > '1900-01-01'
			2 все      expiration_date <= expiration_date + 1 | expiration_date > '1900-01-01'
	*/
			and isnull(expiration_date, @default) <= case when @expired = 1 then getdate() - 1 else isnull(expiration_date, @default) + 1 end
			and isnull(expiration_date, @default) >  case when @expired = 0 then getdate() - 1 else '1900-01-01' end
			
			and d.archive = 0
			order by user_change_date desc
		end	/* @creative_OR_domaine <> 1 */	
		

		create table #sd (domaines varchar(8000), document_id uniqueidentifier)
		create table #sc (creatives varchar(8000), document_id uniqueidentifier)
				
		insert into #sd
		select d.name
		+ ' <A onclick="return confirm(''Отвязать?'')" '
		+ 'HREF="/doc/xt_delete.jsp?domaine_nmb=' + cast(domaine_nmb as varchar(10)) 
		+ '&document_id=' + cast(t.id as varchar(36)) + '"><img border="0" src="/include/img/delete.png"></img></A>'
    	domaines, 
		document_id
		from #t_select_all t
		join t_document_domaine cd on cd.document_id = t.id
		join t_domaine d on domaine_nmb = d.nmb
		where num >= @num1 and num <= @num2

		insert into #sc
		select cast(creative_nmb as varchar(10)) creatives, 
		document_id
		from #t_select_all d
		join t_creative_document cd on cd.document_id = d.id
		where num >= @num1 and num <= @num2

		exec up_sum_string  
		@table_name = '#sd', 
		@key_field_name = 'document_id',
		@string_field_name = 'domaines',
		@separator = ' &nbsp; '
		
		exec up_sum_string  
		@table_name = '#sc', 
		@key_field_name = 'document_id',
		@string_field_name = 'creatives',
		@separator = '; '

		select count(*) cnt from #t_select_all
		
		if(@num1 is null and @num2 is null) select * from #t_select_all 
		if(@num1 is not null and @num2 is not null) 
			select t.*, 
			isnull(domaines, '') domaines,
			isnull(creatives, '') creatives 
			from #t_select_all t
			left join #sd d on t.id = d.document_id
			left join #sc c on t.id = c.document_id
			where num >= @num1 and num <= @num2
		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- select
	-- sp_document 'select', @id = '4608FF2C-E234-4A8C-B913-0FB02248F261'
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select')
	begin
		select dc.*, 
		t.name document_type_name, 
		t.eng_name eng_document_type_name, 
		isnull(u.full_name, '') full_name,
		case when isnull(expiration_date, GETDATE()) > GETDATE() - 1
			then 0
			else 1
		end expire
		from vt_document dc
		join c_document_type t on document_type_id = t.id
		left join s_user u on [user_id] = u.id
		where dc.id = @id and dc.archive = 0

		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- select_creative
	-- sp_document 'select_creative', @id = '861D27E8-4B82-4791-A580-089E8460ACD6'
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select_creative')
	begin
		select creative_nmb
		from vt_document dc
		join t_creative_document cd on cd.document_id = dc.id
		where dc.id = @id and dc.archive = 0
		order by creative_nmb

		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- select_domaine
	-- sp_document 'select_domaine', @id = '861D27E8-4B82-4791-A580-089E8460ACD6'
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select_domaine')
	begin
		select d.*
		from vt_document dc
		join t_document_domaine cd on cd.document_id = dc.id
		join t_domaine d on domaine_nmb = d.nmb
		where dc.id = @id and dc.archive = 0
		order by d.name

		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- create
	-- sp_document 'create', @name = 'ГП 2', @document_type_id = '3C877CB1-4836-4587-8900-4BB25D30CA0A', @description = 'gawdfwerf', @expiration_date = '2013-11-21', @creative_nmb = 55390 
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'create')
	begin
	 	select @id = newid()

		insert into t_document (id, document_type_id, name, description, expiration_date, archive, [user_id], user_change_date)
		select @id, @document_type_id, isnull(@name, ''), isnull(@description, ''), @expiration_date, 0, @user_id, GETDATE()

		select @id id

		if(@domaine is not null)
			exec sp_document_domaine 'create', @domaine = @domaine, @document_id = @id

    if (@file_instance_nmbs is not null) begin

      INSERT INTO t_document_file (id, file_instance_nmb, document_id)
        SELECT newid(), cast(s.[id] AS INT), @id
        FROM dbo.uf_SplitWithCTE(@file_instance_nmbs, ',',0) s

    end
		-------------------------------			
		--> привязать список доменов			
		if(@domaines is not null)
		begin
			select @i = charindex(';', @domaines)
			while(@i > 0)
			begin
				select @domaine = substring(@domaines, 0, @i)
				if(len(@domaine) > 0)
				begin 
					select @domaine = ltrim(rtrim(@domaine))
				
					exec sp_document_domaine 'create', 
					@domaine = @domaine, 
					@document_id = @id 
				end

				select @domaines = substring(@domaines, @i + 1, len(@domaines))
				select @i = charindex(';', @domaines)
			end
		end
		--< привязать список доменов
		-------------------------------			
		
		
		if(@creative_nmb is not null)
		exec sp_creative_document 'create', @creative_nmb = @creative_nmb, @document_id = @id

		-------------------------------			
		--> привязать список креативов			
		if(@creatives is not null)
		begin
			select @i = charindex(';', @creatives)
			while(@i > 0)
			begin
				select @creative = substring(@creatives, 0, @i)
				if(len(@creative) > 0)
				begin 
					select @creative_nmb = cast(ltrim(rtrim(@creative)) as int)
				
					exec sp_creative_document 'create', 
					@creative_nmb = @creative_nmb, 
					@document_id = @id 
				end

				select @creatives = substring(@creatives, @i + 1, len(@creatives))
				select @i = charindex(';', @creatives)
			end
		end
		--< привязать список креативов
		-------------------------------	

		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- change
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'change')
	begin
		update t_document set
		document_type_id = isnull(@document_type_id, document_type_id), 
		name = isnull(@name, name), 
		description = isnull(@description, description), 
		expiration_date = @expiration_date,
		[user_id] = isnull(@user_id, [user_id]), 
		user_change_date = GETDATE()
		where id = @id

		-------------------------------			
		--> привязать список доменов			
		if(@domaines is not null)
		begin
			select @i = charindex(';', @domaines)
			while(@i > 0)
			begin
				select @domaine = substring(@domaines, 0, @i)
				if(len(@domaine) > 0)
				begin 
					select @domaine = ltrim(rtrim(@domaine))
				
					exec sp_document_domaine 'create', 
					@domaine = @domaine, 
					@document_id = @id 
				end

				select @domaines = substring(@domaines, @i + 1, len(@domaines))
				select @i = charindex(';', @domaines)
			end
		end
		--< привязать список доменов
		-------------------------------	

		-------------------------------			
		--> привязать список креативов			
		if(@creatives is not null)
		begin
			select @i = charindex(';', @creatives)
			while(@i > 0)
			begin
				select @creative = substring(@creatives, 0, @i)
				if(len(@creative) > 0)
				begin 
					select @creative_nmb = cast(ltrim(rtrim(@creative)) as int)
				
					exec sp_creative_document 'create', 
					@creative_nmb = @creative_nmb, 
					@document_id = @id 
				end

				select @creatives = substring(@creatives, @i + 1, len(@creatives))
				select @i = charindex(';', @creatives)
			end
		end
		--< привязать список креативов
		-------------------------------	

		select @id id
		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- delete
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'delete')
	begin
		delete from t_creative_document where document_id = @id
		delete from t_document_file where document_id = @id
		delete from t_document_domaine where document_id = @id

		update t_document 
		set archive = 1
		where id = @id

		select @id id
		return
	end

/*
grant execute on [sp_document] to admin_zone_role
*/
GO
GRANT EXECUTE ON [dbo].[sp_document] TO [admin_zone_role]
GO