SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_document_domaine]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_document_domaine]
GO

/*
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_document_domaine]') AND type in (N'P', N'PC'))
 drop procedure sp_document_domaine
*/


CREATE PROCEDURE [dbo].[sp_document_domaine]

	@mode varchar(50) = null,
 
	@id uniqueidentifier = null,
	@domaine_nmb int = null,
	@domaine varchar(250) = null,
	@document_id uniqueidentifier = null,
	
	@user_id [uniqueidentifier] = null
 
AS

	-----------------------------------------------------------------------------------------------------------
	-- create
	-- sp_document_domaine 'create', @domaine = 'mail.ru', @document_id = '67DD86DE-F4C1-425D-8513-70C7DBB6581C' 
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'create')
	begin
		select @domaine_nmb = nmb from t_domaine where name = @domaine
		if(@domaine_nmb is null)
		begin
			insert into t_domaine (name)
			select @domaine
					
			select @domaine_nmb = nmb from t_domaine where name = @domaine
		end	
		
		select @id = id 
		from t_document_domaine
		where domaine_nmb = @domaine_nmb and document_id = @document_id
		
		if(@id is null)
		begin
			select @id = newid()

			insert into t_document_domaine (id, domaine_nmb, document_id)
			select @id, @domaine_nmb, @document_id
		end

		select @id id
		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- delete
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'delete')
	begin
		delete from t_document_domaine
		where domaine_nmb = @domaine_nmb and document_id = @document_id

		update t_document set
		[user_id] = isnull(@user_id, [user_id]), 
		user_change_date = GETDATE()
		where id = @document_id
		return
	end

	
/*
grant execute on [sp_document_domaine] to admin_zone_role
*/
GO
GRANT EXECUTE ON [dbo].[sp_document_domaine] TO [admin_zone_role]
GO