SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_document_file]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_document_file]
GO


CREATE PROCEDURE [dbo].[sp_document_file]

	@mode varchar(50) = null,
 
	@id uniqueidentifier = null,
	@file_instance_nmb int = null,
	@document_id uniqueidentifier = null,
	
	@user_id [uniqueidentifier] = null
 
AS

	-----------------------------------------------------------------------------------------------------------
	-- create
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'create')
	begin

		select @id = newid()

    INSERT INTO dbo.t_document_file (id, file_instance_nmb, document_id)
      SELECT
        @id,
        nmb,
        @document_id
      FROM dbo.t_file_instance
      WHERE nmb = @file_instance_nmb

    UPDATE dbo.t_document
    SET
      [user_id]        = isnull(@user_id, [user_id]),
      user_change_date = GETDATE()
    WHERE id = @document_id


		select @id id
		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- delete
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'delete')
	begin
		delete from t_document_file
		where id = @id

		update t_document set
		[user_id] = isnull(@user_id, [user_id]), 
		user_change_date = GETDATE()
		where id = @document_id
		
		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- select_file
	-- [sp_document_file] 'select_file', @document_id = '3522908D-53A8-402F-8B10-01B5E4AE8E72'
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select_file')
	begin
		select d.id, file_instance_nmb, width, height, mime_type_nmb, fi.*
		from t_document_file d (nolock)
		join vt_file_instance fi on file_instance_nmb = fi.nmb
		join vt_file f on file_nmb = f.nmb
		where document_id = @document_id
		order by fi.nmb

		return
	end

	
/*
grant execute on [sp_document_file] to admin_zone_role 
*/
GO
GRANT EXECUTE ON [dbo].[sp_document_file] TO [admin_zone_role]
GO
