SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_creative_article]') AND type in (N'P', N'PC'))
 drop procedure sp_moderation_creative_article
GO

/*
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_creative_article]') AND type in (N'P', N'PC'))
 drop procedure sp_moderation_creative_article
*/

/*
	select * from t_creative_version_tns_article

	select * from v_tns_article 
	where lev in (3) AND status in ('A', 'N')
*/
CREATE PROCEDURE [dbo].[sp_moderation_creative_article]

	@mode varchar(50) = 'select_all',

	@nmb int = null,
	@creative_version_nmb int = null,
	@str varchar(50) = null,
	
	@articles_str varchar(8000) = null


AS

	declare @article varchar(100), @i int, @i2 int

	-----------------------------------------------------------------------------------------------------------
	-- change
	-- [sp_moderation_creative_article] @mode = 'change', @creative_version_nmb = 38810, @articles_str = ' [221] [225] [192]' 
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'change')
	begin
		delete from t_creative_version_tns_article
		where creative_version_nmb = @creative_version_nmb
	
		select @i = charindex('[', @articles_str)
		select @i2 = charindex(']', @articles_str)
		while(@i > 0)
		begin
			select @article = substring(@articles_str, @i + 1, @i2 - @i - 1)
			select @nmb = cast(@article as int)			

			insert into t_creative_version_tns_article (creative_version_nmb, tns_article_nmb)
			select @creative_version_nmb, @nmb
							
			select @articles_str = substring(@articles_str, @i2 + 1, len(@articles_str))
			select @i = charindex('[', @articles_str)
			select @i2 = charindex(']', @articles_str)
		end



		return
	end
	
	-----------------------------------------------------------------------------------------------------------
	-- create
	-- sp_moderation_creative_article 'create', @creative_version_nmb = 38810, @nmb = 225
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'create')
	begin
		if((select count(*) from t_creative_version_tns_article (nolock)
			where creative_version_nmb = @creative_version_nmb
			and tns_article_nmb = @nmb) = 1) return


		insert into t_creative_version_tns_article (creative_version_nmb, tns_article_nmb)
		select @creative_version_nmb, @nmb

		return
	end


	-----------------------------------------------------------------------------------------------------------
	-- delete
	-- sp_moderation_creative_article 'delete', @creative_version_nmb = 20047, @nmb = 192
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'delete')
	begin
		delete from t_creative_version_tns_article
		where creative_version_nmb = @creative_version_nmb
		and tns_article_nmb = @nmb
 
		return
	end



	-----------------------------------------------------------------------------------------------------------
	-- select
	-- sp_moderation_creative_article 'select', @creative_version_nmb = 20047
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select')
	begin
		select sid nmb, a.name 
		from t_creative_version_tns_article (nolock) ca
		join v_tns_article a on tns_article_nmb = sid
		where creative_version_nmb = @creative_version_nmb

		return
	end


	-----------------------------------------------------------------------------------------------------------
	-- select_all
	-- sp_moderation_creative_article 'select_all', @creative_version_nmb = 20047, @str = 'бытовые'
	-- sp_moderation_creative_article 'select_all', @creative_version_nmb = 38812
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select_all')
	begin
		select pa.name parent_name, pa.sid parent_nmb, a.sid nmb, a.name, case when ca.tns_article_nmb is not null then 1 else 0 end ok 
		into #t_select_all
		from v_tns_article a
		join v_tns_article pa on pa.sid = a.grid
		left join t_creative_version_tns_article (nolock) ca on tns_article_nmb = a.sid and creative_version_nmb = @creative_version_nmb
		where (a.lev in (3) AND a.status in ('A', 'N')
			and (pa.name + a.name) like '%' + ISNULL(@str, '') + '%') or a.sid = -3
		order by pa.name, a.name
		
		select t.*, parent_ok
		from #t_select_all t
		join
		(
			select parent_nmb, SUM(ok) parent_ok
			from #t_select_all
			group by parent_nmb
		) p on t.parent_nmb = p.parent_nmb
		order by parent_name, name

		return
	end


/*
grant execute on sp_moderation_creative_article to admin_zone_role
*/
GO
grant execute on sp_moderation_creative_article to admin_zone_role
