SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_creative_brand]') AND type in (N'P', N'PC'))
 drop procedure sp_moderation_creative_brand
GO

/*
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_creative_brand]') AND type in (N'P', N'PC'))
 drop procedure sp_moderation_creative_brand
*/

/*
	select * from t_creative_version_tns_brand

	select * from v_tns_brand 
	where status in ('A', 'N')
	order by bid
*/
CREATE PROCEDURE [dbo].[sp_moderation_creative_brand]

	@mode varchar(50) = 'select_all',

	@nmb int = null,

	@creative_version_nmb int = null,
	@str varchar(50) = null,
	
	@brands_str varchar(8000) = null


AS

	declare @brand varchar(100), @i int, @i2 int

	-----------------------------------------------------------------------------------------------------------
	-- change
	-- [sp_moderation_creative_brand] @mode = 'change', @creative_version_nmb = 38810, @brands_str = ' [40] [604447]' 
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'change')
	begin
		delete from t_creative_version_tns_brand
		where creative_version_nmb = @creative_version_nmb
	
		select @i = charindex('[', @brands_str)
		select @i2 = charindex(']', @brands_str)
		while(@i > 0)
		begin
			select @brand = substring(@brands_str, @i + 1, @i2 - @i - 1)
			select @nmb = cast(@brand as int)			

			insert into t_creative_version_tns_brand (creative_version_nmb, tns_brand_nmb)
			select @creative_version_nmb, @nmb
							
			select @brands_str = substring(@brands_str, @i2 + 1, len(@brands_str))
			select @i = charindex('[', @brands_str)
			select @i2 = charindex(']', @brands_str)
		end


		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- create
	-- sp_moderation_creative_brand 'create', @creative_version_nmb = 38810, @nmb = 40
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'create')
	begin
		if((select count(*) from t_creative_version_tns_brand (nolock)
			where creative_version_nmb = @creative_version_nmb
			and tns_brand_nmb = @nmb) = 1) return


		insert into t_creative_version_tns_brand (creative_version_nmb, tns_brand_nmb)
		select @creative_version_nmb, @nmb

		return
	end


	-----------------------------------------------------------------------------------------------------------
	-- delete
	-- sp_moderation_creative_brand 'delete', @creative_version_nmb = 20047, @nmb = 2180
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'delete')
	begin
		delete from t_creative_version_tns_brand
		where creative_version_nmb = @creative_version_nmb
		and tns_brand_nmb = @nmb
 
		return
	end




	-----------------------------------------------------------------------------------------------------------
	-- select
	-- sp_moderation_creative_brand 'select', @creative_version_nmb = 38810
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select')
	begin
		select bid nmb, a.name
		from t_creative_version_tns_brand (nolock) ca
		join v_tns_brand a on tns_brand_nmb = bid
		where creative_version_nmb = @creative_version_nmb

		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- select_all
	-- sp_moderation_creative_brand 'select_all', @creative_version_nmb = 20047, @str = 'lg'
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select_all')
	begin
		select a.bid nmb, a.name, case when ca.tns_brand_nmb is not null then 1 else 0 end ok 
		from v_tns_brand a
		left join t_creative_version_tns_brand (nolock) ca on tns_brand_nmb = bid and creative_version_nmb = @creative_version_nmb
		where status in ('A', 'N')
		and a.name like '%' + ISNULL(@str, '') + '%'
		order by case when ltrim(rtrim(a.name)) = ISNULL(@str, '') then 0 else 1 end, a.name 

		return
	end



/*
grant execute on sp_moderation_creative_brand to admin_zone_role
*/
GO
grant execute on sp_moderation_creative_brand to admin_zone_role
