GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_creative_reason]') AND type in (N'P', N'PC'))
drop procedure [sp_moderation_creative_reason]
GO

CREATE PROCEDURE [dbo].[sp_moderation_creative_reason]

	@mode varchar(50) = 'select_all',
	@id uniqueidentifier = null,
	@moderator_name nvarchar(300) = null,
	@name nvarchar(300) = null,
	@sort int = null,
	@text nvarchar(max) = null,
	@reason_object_id uniqueidentifier = null,
	@reason_object_link_nmb int = null,
	@reason_type_id uniqueidentifier = null,
	@RUEN varchar(10) = null,

	@site_nmb varchar(5000) = null,
	@geo_nmb varchar(5000) = null,
	@object_nmb varchar(5000) = null,

	@archive tinyint = null,
	@creative_version_nmb int = null,
	@macros_nmb int = null,
	@parameter_type int = null,

	@cmd varchar(max) = ''
	 
AS

	DECLARE  @creative_version_nmb_prev INT, @creative_nmb INT, @reason_nmb int, @hasModerated int = 0

	select @creative_nmb = creative_nmb from dbo.vt_creative_version where nmb = @creative_version_nmb

  if (@parameter_type is not null and @macros_nmb is not null) begin
    exec upu_raise_error 300400, 'Do not set both parameters parameter_type and macros_nmb at the same time', NULL
  end

  select @creative_version_nmb_prev = max(nmb)
  from dbo.vt_creative_version
  where nmb < @creative_version_nmb
    and @creative_nmb = creative_nmb
    and status_nmb != 1 and status_nmb != 2

  -- BANNERSTORAGE-4957
  -- Проверка модерировался ли параметр ранее (НЕ для файловых параметров)
  if (@parameter_type is not null) begin
    set @hasModerated = (
    select top 1
    case when cv.value = cvp.value then 1
    else 0
    end hasModerated
    from vt_creative_version_parameter cv
    join vt_creative_version_parameter cvp on cvp.parameter_name = cv.parameter_name
    where cv.creative_version_nmb = @creative_version_nmb and cv.file_instance is null and cv.parameter_type_nmb = @parameter_type
    and cv.value is not null and cvp.value is not null and cvp.creative_version_nmb = @creative_version_nmb_prev)

    if (@hasModerated is null) set @hasModerated = 0
    if (@hasModerated = 0) set @creative_version_nmb_prev = @creative_version_nmb
  end
	-- Поиск версии креатива для файловых параметров
	else
    if (@macros_nmb is not null) begin
      select top 1 creative_version_nmb,
      case
      when cv.status_nmb = 4 or cv.status_nmb = 3 then 1
      else 0
      end hasModerated
      into #creative_version_prev
      from vt_creative_version_parameter cvp
      join t_creative_version cv on cvp.creative_version_nmb=cv.nmb
      where cvp.file_instance = @macros_nmb and
      cv.status_nmb != 1 and cv.status_nmb ! =2
      order by creative_version_nmb desc

      select
      @creative_version_nmb_prev = creative_version_nmb,
      @hasModerated = hasModerated
      from #creative_version_prev
  end

	create table #geo (nmb int, name varchar(500))
	create table #sites (id uniqueidentifier, name varchar(8000))
	create table #geos (id uniqueidentifier, name varchar(8000))
	create table #objects (nmb int, name varchar(8000))

	-----------------------------------------------------------------------------------------------------------
	-- create_type
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'create_type')
	begin
		select @id = newid()
		select @name = rtrim(ltrim(@name))

		if((select count(*) from dbo.vd_reason_type where archive = 0 and [name] = @name) = 0)
			insert into dbo.d_reason_type (id, [name])
			select @id, @name

		select @id id
		return
	end

	-----------------------------------------------------------------------------------------------------------
	-- delete_type
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'delete_type' and not exists(select * from dbo.d_reason r where r.reason_type_id = @id and r.archive = 0))
	begin
		update dbo.d_reason_type set archive = 1 where id = @id
		return
	end


	-----------------------------------------------------------------------------------------------------------
	-- select_all
	-- sp_moderation_creative_reason 'select_all'
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select_all')
	begin

		SELECT
			r.*
		FROM dbo.d_reason r
		WHERE r.archive = 0
					AND (@reason_object_id IS NULL OR
							 exists(SELECT TOP 1 1
											FROM dbo.c_reason_object obj
												JOIN dbo.r_reason_object ro
													ON ro.reason_nmb = r.nmb AND ro.archive = 0 AND ro.object_nmb = obj.nmb
											WHERE obj.archive = 0
														AND obj.id = @reason_object_id
							 ))
					AND r.reason_type_id = isnull(@reason_type_id, r.reason_type_id)

		RETURN
	END


	IF (@mode = 'select')
		BEGIN

			SELECT
				r.*,
				rt.nmb  reason_type_nmb,
				rt.name reason_type_name
			FROM dbo.d_reason r
				JOIN dbo.vd_reason_type rt ON rt.id = reason_type_id AND rt.archive = 0
			WHERE r.id = @id

			RETURN
		END



	if(@mode = 'select_site')
	begin

		SELECT s.*
		FROM dbo.d_reason r
			JOIN dbo.vr_reason_site rs ON reason_id = r.id AND rs.archive = 0
			JOIN dbo.vd_site s ON site_nmb = s.nmb
		WHERE r.id = @id
					AND r.archive = 0
		order by s.name

		return
	end


	if(@mode = 'select_geo')
	begin
		insert into #geo
		select yandex_nmb, name from sqllogc.geobaza_v1.dbo.vt_geo g
		where type = 3


		select g.*
		from dbo.d_reason r
		join dbo.vr_reason_geo rs on reason_id = r.id and r.archive = 0 and rs.archive = 0
		join #geo g on geo_nmb = g.nmb
		where r.id = @id
		order by g.name

		return
	end


	IF (@mode = 'select_object')
		BEGIN

			SELECT g.*
			FROM dbo.d_reason r
				JOIN dbo.r_reason_object rs ON rs.reason_nmb = r.nmb AND r.archive = 0 AND rs.archive = 0
				JOIN dbo.c_reason_object g ON rs.object_nmb = g.nmb AND g.archive = 0
			WHERE r.id = @id
			ORDER BY g.name

			RETURN
		END


	if(@mode = 'create')
	begin
		select @id = newid()

		SELECT @sort = max(ro.sort) + 1
		FROM dbo.d_reason r
			JOIN dbo.r_reason_object ro ON ro.archive = 0 AND r.nmb = ro.reason_nmb
			JOIN dbo.c_reason_object o ON o.archive = 0 AND ro.object_nmb = o.nmb AND o.id = @reason_object_id
		WHERE @reason_type_id = r.reason_type_id
					AND r.archive = 0

		insert into dbo.d_reason (id, [moderator_name], [name], [text], reason_type_id, RUEN)
		select @id, @moderator_name, @name, @text, @reason_type_id, @RUEN

		INSERT INTO dbo.r_reason_object (reason_nmb, object_nmb, sort)
			SELECT r.nmb, o.nmb, @sort
			FROM dbo.c_reason_object o
				join dbo.d_reason r on r.id = @id
			WHERE o.archive = 0 AND o.id = @reason_object_id

		select @id id
		return
	end



	if(@mode = 'change')
	begin
		create table #object (nmb int, sort int, name varchar(500))
		create table #site (name varchar(500), nmb int, is_secure int, red_color tinyint)

		SELECT
				@reason_nmb = nmb,
				@reason_type_id = r.reason_type_id
		FROM dbo.d_reason r
		WHERE r.id = @id AND r.archive = 0

		update dbo.d_reason
		  set [name] = isnull(@name, [name]),
		      [moderator_name] = isnull(@moderator_name, [moderator_name]),
		      [text] = isnull(@text, [text]),
		      [RUEN] = isnull(@RUEN, [RUEN])
		  where id = @id

		if(@geo_nmb is not null and len(@geo_nmb) > 0)
		begin
			EXEC ('insert into #geo select yandex_nmb, name from sqllogc.geobaza_v1.dbo.vt_geo g where yandex_nmb in (' + @geo_nmb + ')')
		end

		if(@site_nmb is not null and len(@site_nmb) > 0)
		begin
			insert into #site
			select name, nmb, is_secure, red_color
			from dbo.vd_site

			EXEC ('delete from #site where nmb not in (' + @site_nmb + ')')
		end

		IF (@object_nmb IS NOT NULL AND len(@object_nmb) > 0)
			BEGIN
				EXEC ('insert into #object select nmb, null, name from dbo.c_reason_object where archive = 0 and nmb in (' + @object_nmb + ')')
			END

		if not exists (select top 1 * from #object)
			begin
				EXEC upu_raise_error @customer_nmb = null, @error_code = 300000,
														 @message_marker = 'Причина отклонения должна быть привязана хотя бы к одному объекту'
			END

		delete from dbo.r_reason_site where reason_id = @id
		delete from dbo.r_reason_geo where reason_id = @id

		insert into dbo.r_reason_site (reason_id, site_nmb)
		select @id, nmb from #site

		insert into dbo.r_reason_geo (reason_id, geo_nmb)
		select @id, nmb from #geo


		UPDATE #object
		SET sort = isnull((SELECT ro.sort
											 FROM dbo.r_reason_object ro
											 WHERE ro.reason_nmb = @reason_nmb AND ro.object_nmb = #object.nmb AND ro.archive = 0),
											(SELECT max(ro.sort) + 1
											 FROM dbo.r_reason_object ro
											 WHERE ro.object_nmb = #object.nmb AND ro.archive = 0))


		DELETE FROM dbo.r_reason_object
		WHERE reason_nmb = @reason_nmb

		INSERT INTO dbo.r_reason_object (reason_nmb, object_nmb, sort)
			SELECT @reason_nmb, nmb, o.sort
			FROM #object o

		select @id id
		return
	end


	-----------------------------------------------------------------------------------------------------------
	-- delete
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'delete')
	begin
		update dbo.d_reason set archive = 1 where id = @id

		UPDATE dbo.r_reason_object
		SET archive = 1
		WHERE reason_nmb = (SELECT nmb
												FROM dbo.d_reason
												WHERE id = @id)

		select @id id
		return
	end


	-----------------------------------------------------------------------------------------------------------
	-- sort
	-- sp_moderation_creative_reason 'sort', @id = '5DF93296-B562-4069-9394-035CCC62B446', @sort = 2
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'sort')
	begin
		DECLARE @sort_new INT, @reason_object_nmb INT
		CREATE TABLE #t_sort (nmb INT, sort INT, sort_new INT)

		SET @sort_new = @sort

		SELECT
				@reason_object_nmb = ro.object_nmb,
				@reason_type_id = r.reason_type_id,
				@sort = ro.sort
		FROM dbo.d_reason r
			JOIN dbo.r_reason_object ro ON ro.reason_nmb = r.nmb AND ro.archive = 0
		WHERE ro.nmb = @reason_object_link_nmb

		INSERT INTO #t_sort
			SELECT
				ro.nmb,
				ro.sort,
				ro.sort
			FROM dbo.d_reason d
				JOIN dbo.r_reason_object ro ON ro.reason_nmb = d.nmb AND ro.archive = 0
			WHERE @reason_object_nmb = ro.object_nmb AND @reason_type_id = d.reason_type_id AND d.archive = 0
			ORDER BY ro.sort

		IF (@sort_new < @sort)
			UPDATE #t_sort
			SET sort_new = sort_new + 1
			WHERE sort >= @sort_new AND sort < @sort
		IF (@sort_new > @sort)
			UPDATE #t_sort
			SET sort_new = sort_new - 1
			WHERE sort <= @sort_new AND sort > @sort

		UPDATE #t_sort
		SET sort_new = @sort_new
		WHERE nmb = @reason_object_link_nmb

		UPDATE dbo.r_reason_object
		SET sort = t.sort_new
		FROM #t_sort t
			JOIN dbo.r_reason_object d ON d.nmb = t.nmb

		return
	end


	if(@mode = 'select_for_object')
	begin
		-- гео, сайты
		insert into #sites
		select reason_id, cast(site_nmb as varchar(1000)) name
		from dbo.vr_reason_site rs
		where rs.archive = 0

		insert into #geos
		select reason_id, cast(geo_nmb as varchar(1000)) name
		from dbo.vr_reason_geo rs
		where rs.archive = 0

		exec up_sum_string
		@table_name = '#sites',
		@key_field_name = 'id',
		@string_field_name = 'name',
		@separator = ';'

		exec up_sum_string
		@table_name = '#geos',
		@key_field_name = 'id',
		@string_field_name = 'name',
		@separator = ';'

		SELECT DISTINCT
			r.id,
			r.nmb,
			ro.sort,
			r.name,
			r.moderator_name,
			rt.nmb                         reason_type_nmb,
			rt.name                        reason_type_name,
			r.text,
			CASE WHEN cr.id IS NULL
				THEN 0
			ELSE 1 END                     ok,
			CASE WHEN crp.id IS NULL
				THEN 0
			ELSE 1 END                     prev_ok,
			isnull(';' + g.name + ';', '') geo,
			isnull(';' + s.name + ';', '') site
		INTO #res_select_for_object
		FROM dbo.d_reason r
			JOIN dbo.vd_reason_type rt ON rt.id = r.reason_type_id AND rt.archive = 0
			JOIN dbo.c_reason_object o ON o.id = @reason_object_id AND o.archive = 0
			JOIN dbo.r_reason_object ro ON ro.object_nmb = o.nmb AND ro.reason_nmb = r.nmb AND ro.archive = 0
			LEFT JOIN dbo.vr_creative_version_reason cr ON r.id = cr.reason_id
																										 AND cr.creative_version_nmb = @creative_version_nmb
																										 AND (cr.macros_nmb IS NULL OR cr.macros_nmb = @macros_nmb)
																										 AND cr.archive = 0
			LEFT JOIN dbo.vr_creative_version_reason crp ON r.id = crp.reason_id
																											AND crp.creative_version_nmb = @creative_version_nmb_prev
																											AND (crp.macros_nmb IS NULL OR crp.macros_nmb = @macros_nmb)
																											AND crp.archive = 0
			LEFT JOIN #sites s ON s.id = r.id
			LEFT JOIN #geos g ON g.id = r.id
		WHERE r.archive = 0
					AND RUEN = ISNULL(@RUEN, RUEN)

    select @hasModerated hasModerated

		if(len(@cmd) > 0)
		begin
			set @cmd = 'select * from #res_select_for_object where (' + @cmd + ') order by reason_type_name, sort'
			exec(@cmd)
		end
		else
			select *
			from #res_select_for_object
			order by reason_type_name, sort


		return
	end

GO
grant execute on [sp_moderation_creative_reason] to admin_zone_role