SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_moderation_creative_reason_stat]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_moderation_creative_reason_stat]
GO
/*
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_creative_reason_stat]') AND type in (N'P', N'PC'))
 drop procedure sp_moderation_creative_reason_stat
*/

-- sp_moderation_creative_reason_stat @begin = '2013-10-01', @end = '2013-10-01', @agency_id = '342168BA-E2B5-455C-AC9B-457B44FCB934'
-- sp_moderation_creative_reason_stat @mode = 'advertiser', @begin = '2013-10-01', @end = '2013-10-01'
CREATE PROCEDURE [dbo].[sp_moderation_creative_reason_stat]
	@mode varchar(50) = 'select',
	@begin datetime,
	@end datetime,
	@advertiser_id uniqueidentifier = null,
	@agency_id uniqueidentifier = null
		
AS

	declare @creative_version table(
		creative_nmb INT,
		creative_version_nmb INT,
		creative_name nvarchar(200), -- like t_creative.name
		creative_version_date varchar(10),
		moderation_info nvarchar(MAX),
		creative_version_status INT
	)

	-- prepare list of creatives with its advertisers & agencyes
	insert into @creative_version(
		creative_nmb,
		creative_version_nmb,
		creative_name,
		creative_version_date,
		moderation_info,
		creative_version_status)
	select
		c.nmb 	creative_nmb,
		cv.nmb 	creative_version_nmb,
		c.name	creative_name,
		convert(varchar(10), cv.moderation_date, 21) creative_version_date,
		cv.moderation_info	moderation_info,
		cv.status_nmb	creative_version_status
	from vt_creative c
	join vt_creative_version cv on creative_nmb = c.nmb
	where cv.moderation_date >= @begin and cv.moderation_date <= @end + 1
				and cv.status_nmb > 2

	select cv.creative_nmb,
		cv.creative_version_nmb,
		cv.creative_name name,
		advertiser_id, advertiser_name, agency_id, agency_name,
		cv.creative_version_date date,
		cv.moderation_info,
		cv.creative_version_status status_nmb
	into #res
	from @creative_version cv
		join prontoc.ado_current.dbo.vt_BannerStore_Creative_Agency_Advertiser2 a
			on a.moderation_identity = cast(cv.creative_nmb as nvarchar(128))

	if(@advertiser_id is not null) delete from #res where @advertiser_id <> advertiser_id
	if(@agency_id is not null) delete from #res where @agency_id <> agency_id

	-- prepare list of reasons concat by creative_version
	select distinct cv.creative_version_nmb,
	(
		select r.name + ',' as [text()]
		from vd_reason r
			join vr_creative_version_reason vr on vr.creative_version_nmb = cv.creative_version_nmb and r.id = reason_id
		order by r.nmb
		For XML PATH ('')
	) reason_name
	into #creative_version_reject_reasons
	from @creative_version cv

	select date,
		sum(case when status_nmb = 3 then 1 else 0 end) not_ok,
		sum(case when status_nmb > 3 then 1 else 0 end) ok
	into #r
	from #res
	group by date

	-- First record set
	-- return a list of Agensyes
	select distinct agency_id, agency_name
	from #res
	where agency_id is not null
	order by agency_name

	-- Second record set
	-- return a list of Advertisers
	select distinct advertiser_id, advertiser_name
	from #res
	where advertiser_id is not null
	order by advertiser_name

	-- Third record set
	select SUM(ok) ok, SUM(not_ok) not_ok, SUM(ok + not_ok) all_sum,
	round(100.0 * SUM(not_ok) / SUM(ok + not_ok), 2, 0) prc_not_ok
	from #r

	-- Forth record set
	select r.*, a.reason_name,
	ok, not_ok, ok + not_ok all_sum, 
	round(100.0 * not_ok / (ok + not_ok), 2, 0) prc_not_ok
	from #res r
	join #creative_version_reject_reasons a on a.creative_version_nmb = r.creative_version_nmb and a.reason_name is not NULL
	join #r on #r.date = r.date
	order by r.date

GO
GRANT EXECUTE ON [sp_moderation_creative_reason_stat] to [admin_zone_role]
GO