IF OBJECT_ID('dbo.sp_moderation_creative_select') is NULL
    EXEC ('create procedure dbo.sp_moderation_creative_select as begin return end')
GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO

-- [sp_moderation_creative_select] @mode = 'select', @creative_version_nmb = 930803 
-- [sp_moderation_creative_select] @creative_version_nmb = 48170
-- [sp_moderation_creative_select] @mode = 'banner', @creative_version_nmb = 3543
-- [sp_moderation_creative_select] @mode = 'all_macros', @creative_version_nmb = 30986
-- [sp_moderation_creative_select] @mode = 'all_macros', @creative_version_nmb = 23206
ALTER PROCEDURE [dbo].[sp_moderation_creative_select]
    @mode varchar(50) = 'select',
    @creative_version_nmb int = null,
    @creative_nmb int = null
AS
begin
    declare @advertiser_name varchar(1000), @max_order_nmb int, @prev_order_nmb int

    if (@creative_version_nmb is null and @creative_nmb is not null) begin
        select top 1 @creative_version_nmb = cv.nmb
        from t_creative_version cv (nolock)
            join t_creative c (nolock) on c.nmb = cv.creative_nmb and cv.is_last_version = 1
        order by cv.nmb desc
    end

    if(@mode = 'get_last_version')
    begin
        select @max_order_nmb = max(order_nmb)
        from t_creative_version (nolock)
        where creative_nmb = @creative_nmb

        select * from t_creative_version (nolock)
        where creative_nmb = @creative_nmb and order_nmb = @max_order_nmb
    end

    if(@mode = 'select')
    begin
        select @max_order_nmb = max(cv.order_nmb)
        from t_creative_version cv (nolock)
        join t_creative_version cv2 (nolock)
            on cv.creative_nmb = cv2.creative_nmb and cv2.nmb = @creative_version_nmb

        select @advertiser_name = a.advertiser_name
        from vt_creative c
        join t_creative_version cv (nolock) on creative_nmb = c.nmb
        join prontoc.ado_current.dbo.vt_BannerStore_Creative_Agency_Advertiser a
            on cast(c.nmb as varchar(100)) = a.outer_object_id
        where cv.nmb = @creative_version_nmb

        set @prev_order_nmb = (
            select top 1 *
            from (
                select top 2 cv_ord_lst.order_nmb
                from t_creative_version cv_ord_lst (nolock)
                where cv_ord_lst.status_nmb != 1
                    and cv_ord_lst.creative_nmb = (
                        select creative_nmb
                        from t_creative_version (nolock)
                        where nmb = @creative_version_nmb
                    )
                order by cv_ord_lst.order_nmb desc
            ) as cv_ord
            order by cv_ord.order_nmb
        )

        if @prev_order_nmb = @max_order_nmb
            set @prev_order_nmb = 0;

        declare @layout_nmb int

        -- layout_nmb нужен в модерации для определеня смарт-тго креативов (== 44)
        select @layout_nmb = tvlc.layout_nmb
        from t_template_version_layout_code tvlc
            join t_creative_version cv on cv.layout_code_nmb = tvlc.nmb
        where cv.nmb = @creative_version_nmb

        select
            isnull(@advertiser_name, '') advertiser_name,
            cv.[creative_nmb],
            c.name creative_name,
            c.tag creative_tag,
            c.creative_group_nmb,
            cv.status_nmb,
            cv.moderation_priority,
            s.name status_name,
            c.customer_nmb, cs.name [customer_name],
            cv.date_create,
            cv.expire_date, case when getdate() < cv.expire_date then 1 else 0 end actual,

            case when cv.user_id is null then 0 else 1 end has_lock_moderator,
            cv.lock_moderation_date,
            u.id lock_moderator_id, isnull(u.full_name, '') lock_moderator_full_name,

            case when cv_prev.user_id is null then 0 else 1 end has_moderator,
            cv_prev.moderation_date,
            u_prev.id moderator_id, isnull(u_prev.full_name, '') moderator_full_name,

            cv.note,
            cv.wrong_moderation_result,
            isnull(cv.moderation_info, '') moderation_info,

            t.name template_name, tv.template_nmb, tt.name template_type_name, template_type_nmb,

            cvp.value alt,
            width = coalesce(cv.width, dbo.uf_creative_version_get_width(@creative_version_nmb)),
            height = coalesce(cv.height, dbo.uf_creative_version_get_height(@creative_version_nmb)),

            isnull(@layout_nmb, 0) layout_nmb,
            c.is_moderated_externally

        from t_creative_version cv (nolock)
        join t_creative c (nolock) on cv.creative_nmb = c.nmb
        join c_creative_status (nolock) s on cv.status_nmb = s.nmb
        join vs_customer cs on customer_nmb = cs.nmb and cs.archive = 0

        join t_template_version tv (nolock) on cv.template_version_nmb = tv.nmb
        join t_template t (nolock) on tv.template_nmb = t.nmb
        join t_template_type tt (nolock) on t.template_type_nmb = tt.nmb

        left join vs_user u on cv.[user_id] = u.id
        left join t_creative_version cv_prev (nolock) on cv_prev.creative_nmb = cv.creative_nmb and cv_prev.order_nmb = @prev_order_nmb
        left join vs_user u_prev on cv_prev.[user_id] = u_prev.id

        left join vt_creative_version_parameter cvp on cvp.creative_version_nmb = cv.nmb and parameter_type_nmb = 9

        where cv.nmb = @creative_version_nmb

        return
    end

    if(@mode = 'site')
    begin
        select cs.site_nmb, cs.exclude, s.name site_name,
        case when rp.nmb is null then 0 else 1 end red_pixel
        from dbo.uf_get_creative_version_sites(@creative_version_nmb) cs
        join vd_site s on s.nmb = site_nmb
        left join
        (
            select * from vd_site
            where name like '%главная%'
            and is_secure = 0
        ) rp
        on rp.nmb = s.nmb
        order by s.name

        return
    end

    if(@mode = 'geo')
    begin
        select cs.*, s.name
        from vt_creative_version_geo cs
        join sqllogc.geobaza_v1.dbo.vt_geo s on yandex_nmb = geo_nmb and type = 3
        where cs.creative_version_nmb = @creative_version_nmb
        order by s.name

        return
    end

    if(@mode = 'banner')
    begin

        declare @initial_width int = 0, @initial_height int = 0

        select @initial_width = value from vt_creative_version_parameter where parameter_name = 'INITIAL_WIDTH' and creative_version_nmb = @creative_version_nmb
        select @initial_height = value from vt_creative_version_parameter where parameter_name = 'INITIAL_HEIGHT' and creative_version_nmb = @creative_version_nmb

        select
            p.parameter_nmb,
            p.parameter_order_nmb,
            p.[value] banner_nmb,
            p.banner_name,
            p.width,
            p.height,
            ISNULL(@initial_width, 0)        initial_width,
            ISNULL(@initial_height, 0)    initial_height,
            case when m.name = 'application/x-shockwave-flash' then 'image/swf' else m.name end mime_type_name,
            p.size,
            p.mime_type_nmb,
            p.flash_version,
            file_instance,
            content_group_nmb,
            parameter_name
        from vt_creative_version_parameter p
        join [dbo].t_creative_version cv on cv.nmb = p.creative_version_nmb
        join [dbo].t_template_version tv on cv.template_version_nmb = tv.nmb
         join [dbo].t_template_parameter tp on p.parameter_nmb = tp.parameter_nmb and tv.nmb = tp.template_version_nmb and tp.is_system = 0
        join [dbo].c_mime_type m on m.nmb = mime_type_nmb
        where parameter_type_nmb = 2 and creative_version_nmb = @creative_version_nmb
            and parameter_name not like '%DOCUMENT%'
        order by parameter_name

        return
    end

    if(@mode = 'doc')
    begin
        SELECT
            p.parameter_nmb,
            p.parameter_order_nmb,
            p.[value]       banner_nmb,
            p.banner_name,
            p.width,
            p.height,
            CASE WHEN m.name = 'application/x-shockwave-flash'
                THEN 'image/swf'
            ELSE m.name END mime_type_name,
            p.size,
            p.mime_type_nmb,
            p.flash_version,
            p.file_instance,
            fi.file_nmb,
            m.content_group_nmb,
            p.parameter_name
        FROM dbo.vt_creative_version_parameter p
            JOIN dbo.vt_file_instance fi ON fi.nmb = p.file_instance
            JOIN dbo.c_mime_type m ON m.nmb = p.mime_type_nmb
        WHERE parameter_type_nmb = 2 AND
                    creative_version_nmb = @creative_version_nmb
                    AND p.parameter_name LIKE '%DOCUMENT%'
        ORDER BY p.parameter_name

        return
    end
end

GO
grant execute on [sp_moderation_creative_select] to admin_zone_role
