﻿if object_id('dbo.sp_moderation_creative_select_all') is null
    exec ('create procedure dbo.sp_moderation_creative_select_all as begin return end')
go
set ansi_nulls on;
set quoted_identifier on;
go

ALTER PROCEDURE [dbo].[sp_moderation_creative_select_all]
    @creative_nmb                     int = null,
    @status_nmb                       int = null,
    @date_begin                       datetime = null,
    @date_end                         datetime = null,
    @creative_name_pattern            nvarchar(max) = null,
    @customer_nmb                     varchar(500) = null,  -- массив номеров через запятую
    @creative_tag                     nvarchar(100) = null,
    @creative_group_nmb               nvarchar(100) = null, -- группа креативов
    @creative_url                     nvarchar(500) = null,
    @advertiser_name                  nvarchar(500) = null,
    @site_nmb                         int = null,
    @put_creatives_to_rtb             int = null,
    @template_nmb                     varchar(500) = null,    -- массив номеров через запятую
    @lock_user_id                     nvarchar(36) = null,

    @mi_1                             int = null,
    @mi_2                             int = null,

    @moderation_priority_1            int = null,  -- приоритет модерации
    @moderation_priority_2            int = null,

    @num1                             int = 1,
    @num2                             int = 500
as
begin

    set nocount on;

    set transaction isolation level read uncommitted;

    declare @fetched int = 0, @max_fetched int = 500, @customer_inversion int = 0;
    declare -- см. MSDEVSUP-3989
    @loc_creative_nmb                     int = @creative_nmb,
    @loc_status_nmb                         int = @status_nmb,
    @loc_date_begin                         datetime = @date_begin,
    @loc_date_end                             datetime = @date_end,
    @loc_creative_name_pattern     nvarchar(max) = @creative_name_pattern,
    @loc_customer_nmb                     varchar(500) = @customer_nmb,
    @loc_creative_tag                     nvarchar(100) = @creative_tag,
    @loc_creative_group_nmb          nvarchar(100) = @creative_group_nmb,
    @loc_creative_url                     nvarchar(500) = @creative_url,
    @loc_advertiser_name                 nvarchar(500) = @advertiser_name,
    @loc_site_nmb                             int = @site_nmb,
    @loc_put_creatives_to_rtb     int = @put_creatives_to_rtb,
    @loc_template_nmb                     varchar(500) = @template_nmb,
    @loc_lock_user_id                     nvarchar(36) = @lock_user_id,

    @loc_mi_1                                     int = @mi_1,
    @loc_mi_2                                     int = @mi_2,

    @loc_moderation_priority_1  int = @moderation_priority_1,
    @loc_moderation_priority_2  int = @moderation_priority_2,

    @loc_num1                                     int = @num1,
    @loc_num2                                     int = @num2

    if (@loc_creative_name_pattern is not null)
        select @loc_creative_name_pattern = '%' + @loc_creative_name_pattern + '%';

    if (@loc_creative_tag is not null)
        select @loc_creative_tag = '%' + @loc_creative_tag + '%';

    if (@loc_creative_url is not null)
        select @loc_creative_url = '%' + @loc_creative_url + '%';

    if (@loc_advertiser_name is not null)
        select @loc_advertiser_name = '%' + @loc_advertiser_name + '%';

    DECLARE @customer_nmb_table AS TABLE (NMB INT)

    if (@loc_customer_nmb is not null) begin
        insert into @customer_nmb_table(nmb)
            select CAST(ss.[id] AS INT)
            from dbo.uf_SplitWithCTE(@loc_customer_nmb, ',',0) ss

        -- если среди переданных NMB есть -1 то выводим все креативы КРОМЕ креативов с переданными dps_nmb
        IF exists(select 1 from @customer_nmb_table where nmb = -1) BEGIN
            SELECT @customer_inversion = 1
        END

    end

    DECLARE @template_nmb_table AS TABLE (NMB INT)

    if (@loc_template_nmb is not null) begin
        insert into @template_nmb_table(nmb)
            select CAST(ss.[id] AS INT)
            from dbo.uf_SplitWithCTE(@loc_template_nmb, ',',0) ss
    end

    ------------------------------------------------------------
    -- Заполняем таблицу статусов креатива
    ------------------------------------------------------------

    declare @creative_status_table table (nmb int, name nvarchar(50))

    insert into @creative_status_table
        select nmb, name
        from c_creative_status

    insert into @creative_status_table values (0, 'Не отмодерирован')

    ------------------------------------------------------------
    -- Отфильтровываем верхние 500 креативов
    ------------------------------------------------------------

    create table #selected (
        nmb                                         int not null,
        status_nmb                             int,     -- статус креатива
        has_lock_moderator            int,    -- заблокировал ли кто то креатив
        moderation_request_date datetime,
        moderation_priority     int   -- приоритет модерации
    );

    declare @template_versions table(nmb int primary key, template_nmb int);

    if (@loc_template_nmb is not null) begin
        insert into @template_versions
            select tv.nmb, tv.template_nmb
            from dbo.t_template_version tv (NOLOCK)
                join @template_nmb_table tt on tt.nmb = tv.template_nmb
    end

    if (@loc_put_creatives_to_rtb is not null and @loc_template_nmb is null) begin
        insert into @template_versions
            select nmb, template_nmb
            from dbo.t_template_version
            where put_creatives_to_rtb = @loc_put_creatives_to_rtb
    end

    -- два одинаковых запроса, но если не указан номер креатива, то используется хинт
    -- чтобы к t_creative_version присоединялась t_creative, а не наоборот
    -- при этом удаётся использовать индекс по status_nmb
    -- если же номер креатива указан, то наоборот выгоднее начать с t_creative
    -- а вообще наверное самым правильным будет переписать это место так, чтобы
    -- запрос собирался шаблоном и не было лишних предикатов. Сейчас обилие предикатов
    -- не даёт оптимизатору выбрать оптимальный план исполнения
    if @loc_creative_nmb is not null or @loc_creative_group_nmb is not null
        begin
            insert #selected
            select top (@max_fetched)
                cv.nmb,
                cv.status_nmb,
                case
                    when cv.[user_id] is null then 0
                    else 1
                end,
                cv.moderation_request_date,
                cv.moderation_priority
            from dbo.t_creative_version (NOLOCK) as cv
                join dbo.t_creative (NOLOCK) as c on cv.creative_nmb = c.nmb
                    and cv.order_nmb = c.last_version_order_nmb
                    and (@loc_status_nmb is null or 1 = case
                        when @loc_status_nmb = 0 and cv.status_nmb in (3,4) then 1
                        when @loc_status_nmb = cv.status_nmb and not (cv.status_nmb = 2 and is_ready_to_moderation = 0) then 1
                        else 0
                        end
                    )
                    and (@loc_template_nmb is null or exists(select 1 from @template_versions tvv join @template_nmb_table tt on tt.nmb = tvv.template_nmb where tvv.nmb = cv.template_version_nmb))
                    and (@loc_put_creatives_to_rtb is null or exists(select 1 from @template_versions tv where tv.nmb = cv.template_version_nmb))
                    and (@loc_mi_1 is null or DATEPART(mi, cv.moderation_request_date) >= @loc_mi_1)
                    and (@loc_mi_2 is null or DATEPART(mi, cv.moderation_request_date) <= @loc_mi_2)
                    and (@loc_moderation_priority_1 is null or cv.moderation_priority >= @loc_moderation_priority_1)
                    and (@loc_moderation_priority_2 is null or cv.moderation_priority <= @loc_moderation_priority_2)
                    and (@loc_lock_user_id is null or cv.user_id = @loc_lock_user_id)
                    and (@loc_site_nmb is null or exists(
                        select 1 from dbo.uf_get_creative_version_sites(cv.nmb) cvs
                        where cvs.site_nmb = @loc_site_nmb
                    ))
                    and (@loc_creative_url is null or exists(select 1 from dbo.t_creative_version_param_value (NOLOCK) cvpv
                                                             join dbo.t_string (NOLOCK) s on s.nmb = cvpv.string_nmb and s.value like @loc_creative_url
                                                             where cvpv.creative_version_nmb = cv.nmb))
                    and (@loc_date_begin is null or cv.moderation_request_date >= @loc_date_begin)
                    and (@loc_date_end is null or cv.moderation_request_date <= @loc_date_end)
            where (@loc_creative_nmb is null or c.nmb = @loc_creative_nmb)
                and (@loc_creative_name_pattern is null or c.name like @loc_creative_name_pattern)
                and (@loc_creative_tag is null or c.tag like @loc_creative_tag)
                and (@loc_creative_group_nmb is null or c.creative_group_nmb like @loc_creative_group_nmb)
                and (@loc_customer_nmb is null
                    or (@customer_inversion = 0 and c.customer_nmb in (select nmb from @customer_nmb_table))
                    or (@customer_inversion = 1 and c.customer_nmb not in (select nmb from @customer_nmb_table)))
                -- креативы, модерируемые внешним образом, выводим только если явно указан номер креатива
                and (c.is_moderated_externally = 0 or @loc_creative_nmb is not null)
        end
    else
        begin
            insert #selected
            select top (@max_fetched)
                cv.nmb,
                cv.status_nmb,
                case
                    when cv.[user_id] is null then 0
                    else 1
                end,
                cv.moderation_request_date,
                cv.moderation_priority
            from dbo.t_creative_version (NOLOCK) as cv
                join dbo.t_creative (NOLOCK) as c on cv.creative_nmb = c.nmb
                    and cv.order_nmb = c.last_version_order_nmb
                    and (@loc_status_nmb is null or 1 = case
                        when @loc_status_nmb = 0 and cv.status_nmb in (3,4) then 1
                        when @loc_status_nmb = cv.status_nmb and not (cv.status_nmb = 2 and is_ready_to_moderation = 0) then 1
                        else 0
                        end
                    )
                    and (@loc_template_nmb is null or exists(select 1 from @template_versions tvv join @template_nmb_table tt on tt.nmb = tvv.template_nmb where tvv.nmb = cv.template_version_nmb))
                    and (@loc_put_creatives_to_rtb is null or exists(select 1 from @template_versions tv where tv.nmb = cv.template_version_nmb))
                    and (@loc_mi_1 is null or DATEPART(mi, cv.moderation_request_date) >= @loc_mi_1)
                    and (@loc_mi_2 is null or DATEPART(mi, cv.moderation_request_date) <= @loc_mi_2)
                    and (@loc_moderation_priority_1 is null or cv.moderation_priority >= @loc_moderation_priority_1)
                    and (@loc_moderation_priority_2 is null or cv.moderation_priority <= @loc_moderation_priority_2)
                    and (@loc_lock_user_id is null or cv.user_id = @loc_lock_user_id)
                    and (@loc_site_nmb is null or exists(
                        select 1 from dbo.uf_get_creative_version_sites(cv.nmb) cvs
                        where cvs.site_nmb = @loc_site_nmb
                    ))
                    and (@loc_creative_url is null or exists(select 1 from dbo.t_creative_version_param_value (NOLOCK) cvpv
                                                             join dbo.t_string (NOLOCK) s on s.nmb = cvpv.string_nmb and s.value like @loc_creative_url
                                                             where cvpv.creative_version_nmb = cv.nmb))
                    and (@loc_date_begin is null or cv.moderation_request_date >= @loc_date_begin)
                    and (@loc_date_end is null or cv.moderation_request_date <= @loc_date_end)
            where (@loc_creative_nmb is null or c.nmb = @loc_creative_nmb)
                and (@loc_creative_name_pattern is null or c.name like @loc_creative_name_pattern)
                and (@loc_creative_tag is null or c.tag like @loc_creative_tag)
                and (@loc_creative_group_nmb is null or c.creative_group_nmb like @loc_creative_group_nmb)
                and (@loc_customer_nmb is null
                    or (@customer_inversion = 0 and c.customer_nmb in (select nmb from @customer_nmb_table))
                    or (@customer_inversion = 1 and c.customer_nmb not in (select nmb from @customer_nmb_table)))
                -- креативы, модерируемые внешним образом, выводим только если явно указан номер креатива
                and (c.is_moderated_externally = 0 or @loc_creative_nmb is not null)
                -- без этого хинта mssql почему-то предпочитает фулскан t_creative + nested loop join с t_creative_version
                OPTION (FORCE ORDER)
        end

    -- Выводим результат
    ------------------------------------------------------------
    select count(*) cnt from #selected

    select
        sel.ord                                                         num,
        cv.creative_nmb                                            creative_nmb,
        ISNULL(c.tag, '')                                     creative_tag,
        ISNULL(c.creative_group_nmb, 0)         creative_group_nmb,
        sel.nmb                                                         creative_version_nmb,
        case
        when ltrim(rtrim(c.name)) = ''
            then CAST(cv.creative_nmb as varchar(10))
        else                                                                 c.name
        end                                                                 name,
        cv.status_nmb                                                status_nmb,
        st.name                                                         status_name,

        c.[customer_nmb]                                        customer_nmb,
        s.name                                                             customer_name,

        cv.[moderation_request_date],
        cv.[automoderation_request_date],
        cv.[is_rejected_by_automoderator],                -- версия креатива отклонена автомодерацией

        case
        when cv.[user_id] is null
            then 0
        else 1
        end                                         has_lock_moderator,
        cv.lock_moderation_date,
        isnull(u.full_name, '') lock_full_name,

        banner_count,
        isnull(sites_excl.v, '') sites,

        case when cv.user_id is null then 0 else 1 end has_moderator,
        cv.moderation_priority,
        cv.moderation_date,
        isnull(u.full_name, '') moderator_full_name,

        t.nmb as template_nmb,
        t.name as template_name,
        c.is_moderated_externally
    from
        (select nmb,
         case
         when @loc_status_nmb = 2 then ROW_NUMBER() over (order by has_lock_moderator, moderation_priority desc, moderation_request_date)
         else ROW_NUMBER() over (order by status_nmb, has_lock_moderator, moderation_request_date, moderation_priority desc, nmb)
         end ord
         from #selected) sel
        join dbo.t_creative_version (NOLOCK) cv on cv.nmb = sel.nmb
             and sel.ord between @loc_num1 and @loc_num2
             and 1 = case
                             when @loc_lock_user_id is null then 1
                             when @loc_lock_user_id = cv.user_id then 1
                             else 0
                             end
        join dbo.t_creative (NOLOCK) c on creative_nmb = c.nmb
        join @creative_status_table st on cv.status_nmb = st.nmb
        join dbo.s_customer (NOLOCK) s on c.customer_nmb = s.nmb and s.archive = 0
        left join dbo.vs_user (NOLOCK) u on cv.[user_id] = u.id
        left join
        (
            select creative_version_nmb, count(*) banner_count
            from dbo.vt_creative_version_parameter
            where parameter_type_nmb = 2
            group by creative_version_nmb
        ) b on sel.nmb = b.creative_version_nmb
        outer apply (
            select creative_version_nmb, dbo.SumString(name, '; ') v
                from (
                    select top 4 cvs.creative_version_nmb, s.name
                    from dbo.uf_get_creative_version_sites(sel.nmb) cvs
                        join dbo.d_site s (NOLOCK) on s.nmb = cvs.site_nmb
                    where cvs.exclude = 0
                ) q
            group by creative_version_nmb
        ) sites_excl
        join dbo.t_template_version (NOLOCK) as tv on tv.nmb = cv.template_version_nmb
        join dbo.t_template (NOLOCK) as t on t.nmb = tv.template_nmb
    order by sel.ord
end;
go

grant execute on dbo.sp_moderation_creative_select_all to admin_zone_role
go
