GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_creative_select_history]') AND type in (N'P', N'PC'))
drop procedure [sp_moderation_creative_select_history]
GO
/*
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_creative_select_history]') AND type in (N'P', N'PC'))
 drop procedure sp_moderation_creative_select_history
*/

-- [sp_moderation_creative_select_history] @num1 = 10, @num2 = 100, @creative_name_pattern = 'skoda'
-- [sp_moderation_creative_select_history] @num1 = 1, @num2 = 25, @status_nmb = 3
-- [sp_moderation_creative_select_history] @num1 = 10, @num2 = 345, @status_nmb = 4
-- sp_moderation_creative_select_history @num1 = 1, @num2 = 25, @date_begin = '2014-10-31', @date_end = '2014-10-31' 
-- sp_moderation_creative_select_history @num1 = 1, @num2 = 25, @date_begin = '2014-04-01', @date_end = '2014-04-05', @customer_nmb = '16,5,1', @site_nmb = '2671,1472,113086,107869,9000002' 
CREATE PROCEDURE [dbo].[sp_moderation_creative_select_history]

	@creative_nmb             int = null,
	@status_nmb               int = null,
	@date_begin               datetime = null,
	@date_end                 datetime = null,
	@user_id                  uniqueidentifier = null,
	@creative_name_pattern    varchar(64) = null,
	@customer_nmb             varchar(8000) = null,
	@site_nmb                 varchar(8000) = null,
	@wrong_moderation_result  [tinyint] = null,
	@num1                     int = 1,    -- при пейджинге первая страница передается как 1
	@num2                     int = 25
	
AS

  DECLARE @cmd varchar(8000),
          @Offset INT = @num1 - 1,
          @Limit INT = @num2 - @num1 - 1;

  DECLARE @site TABLE (nmb INT)
  DECLARE @customer TABLE (nmb INT)

  INSERT INTO @site(nmb)
    SELECT cast(s.[id] AS INT)
    FROM dbo.uf_SplitWithCTE(@site_nmb, ',',0) s

  INSERT INTO @customer(nmb)
    SELECT cast(s.[id] AS INT)
    FROM dbo.uf_SplitWithCTE(@customer_nmb, ',',0) s

  DECLARE @Creatives TABLE(
               creative_nmb            int,
               creative_version_nmb    int,
               creative_name           varchar(1024),
               status_nmb              int,
               status_name             varchar(100),
               customer_nmb            int,
               customer_name           varchar(500),
               is_rejected_by_automoderator bit,
               moderator_full_name     varchar(500),
               moderation_date         datetime,
               moderator_id            uniqueidentifier,
               wrong_moderation_result tinyint
               )

  IF (@site_nmb IS NOT NULL) BEGIN

    INSERT INTO @Creatives (
      creative_nmb,
      creative_version_nmb,
      creative_name,
      status_nmb,
      status_name,
      customer_nmb,
      customer_name,
      is_rejected_by_automoderator,
      moderator_full_name,
      moderation_date,
      moderator_id,
      wrong_moderation_result
    )
      SELECT
          'creative_nmb'                  = cv.[creative_nmb],
          'creative_version_nmb'          = cv.nmb,
          'creative_name'                 = c.name,
          'status_nmb'                    = cv.status_nmb,
          'status_name'                   = s.name,
          'customer_nmb'                  = customer_nmb,
          'customer_name'                 = cs.name,
          'is_rejected_by_automoderator'  = cv.is_rejected_by_automoderator,
          'moderator_full_name'           = isnull(u.full_name, ''),
          'moderation_date'               = cv.moderation_date,
          'moderator_id'                  = cv.[user_id],
          'wrong_moderation_result'       = cv.wrong_moderation_result
      FROM t_creative_version cv ( NOLOCK )
        JOIN vt_creative c ON
                             cv.creative_nmb = c.nmb
                             AND (isnull(@creative_nmb, 0) = 0 OR c.nmb = @creative_nmb)
                             AND
                             (isnull(@creative_name_pattern, '') = '' OR c.name LIKE '%' + @creative_name_pattern + '%')
        JOIN c_creative_status s ON cv.status_nmb = s.nmb
        JOIN vs_customer cs ON
                              customer_nmb = cs.nmb
                              AND cs.archive = 0
                              AND (ISNULL(@customer_nmb, '') = '' OR cs.nmb IN (SELECT nmb
                                                                                FROM @customer))
        LEFT JOIN vs_user u ON
                              cv.[user_id] = u.id
                              AND (ISNULL(@user_id, '00000000-0000-0000-0000-000000000000') =
                                   '00000000-0000-0000-0000-000000000000' OR cv.[user_id] = @user_id)
      WHERE
        1 = CASE
            WHEN @status_nmb IS NULL THEN 1
            WHEN @status_nmb = 2 AND @status_nmb = cv.status_nmb AND cv.user_id IS NULL THEN 1
            WHEN @status_nmb = cv.status_nmb THEN 1
            ELSE 0
            END
        AND EXISTS(SELECT 1
                   FROM dbo.uf_get_creative_version_sites(cv.nmb) cvs
                     JOIN @site ss ON ss.nmb = cvs.site_nmb)
        AND (ISNULL(cv.wrong_moderation_result, '') = '' OR @wrong_moderation_result = cv.wrong_moderation_result)
        AND 1 = CASE
                WHEN @status_nmb = 2 THEN 1 -- для 'заблокированных' не проверяем фильтр по датам (BANNERSTORAGE-3098)
                WHEN @date_begin IS NULL THEN 1
                WHEN @date_begin IS NOT NULL AND cv.moderation_date >= @date_begin THEN 1
                ELSE 0
                END
        AND 1 = CASE
                WHEN @status_nmb = 2 THEN 1 -- для 'заблокированных' не проверяем фильтр по датам (BANNERSTORAGE-3098)
                WHEN @date_end IS NULL THEN 1
                WHEN @date_end IS NOT NULL AND cv.moderation_date <= DATEADD(day, 1, @date_end) THEN 1
                ELSE 0
                END
        AND 1 = CASE
                WHEN @user_id IS NOT NULL AND cv.user_id = @user_id THEN 1
                WHEN @user_id IS NULL THEN 1
                ELSE 0
                END

  END ELSE BEGIN

    INSERT INTO @Creatives (
      creative_nmb,
      creative_version_nmb,
      creative_name,
      status_nmb,
      status_name,
      customer_nmb,
      customer_name,
      is_rejected_by_automoderator,
      moderator_full_name,
      moderation_date,
      moderator_id,
      wrong_moderation_result
    )
      SELECT
          'creative_nmb'              = cv.[creative_nmb],
          'creative_version_nmb'      = cv.nmb,
          'creative_name'             = c.name,
          'status_nmb'                = cv.status_nmb,
          'status_name'               = s.name,
          'customer_nmb'              = customer_nmb,
          'customer_name'             = cs.name,
          'is_rejected_by_automoderator'  = cv.is_rejected_by_automoderator,
          'moderator_full_name'       = isnull(u.full_name, ''),
          'moderation_date'           = cv.moderation_date,
          'moderator_id'              = cv.[user_id],
          'wrong_moderation_result'   = cv.wrong_moderation_result
      FROM t_creative_version cv ( NOLOCK )
        JOIN vt_creative c ON
                             cv.creative_nmb = c.nmb
                             AND (isnull(@creative_nmb, 0) = 0 OR c.nmb = @creative_nmb)
                             AND
                             (isnull(@creative_name_pattern, '') = '' OR c.name LIKE '%' + @creative_name_pattern + '%')
        JOIN c_creative_status s ON cv.status_nmb = s.nmb
        JOIN vs_customer cs ON
                              customer_nmb = cs.nmb
                              AND cs.archive = 0
                              AND (ISNULL(@customer_nmb, '') = '' OR cs.nmb IN (SELECT nmb
                                                                                FROM @customer))
        LEFT JOIN vs_user u ON
                              cv.[user_id] = u.id
                              AND (ISNULL(@user_id, '00000000-0000-0000-0000-000000000000') =
                                   '00000000-0000-0000-0000-000000000000' OR cv.[user_id] = @user_id)
      WHERE
        1 = CASE
            WHEN @status_nmb IS NULL THEN 1
            WHEN @status_nmb = 2 AND @status_nmb = cv.status_nmb AND cv.user_id IS NULL THEN 1
            WHEN @status_nmb = cv.status_nmb THEN 1
            ELSE 0
            END
        AND (ISNULL(cv.wrong_moderation_result, '') = '' OR @wrong_moderation_result = cv.wrong_moderation_result)
        AND 1 = CASE
                WHEN @status_nmb = 2 THEN 1 -- для 'заблокированных' не проверяем фильтр по датам (BANNERSTORAGE-3098)
                WHEN @date_begin IS NULL THEN 1
                WHEN @date_begin IS NOT NULL AND cv.moderation_date >= @date_begin THEN 1
                ELSE 0
                END
        AND 1 = CASE
                WHEN @status_nmb = 2 THEN 1 -- для 'заблокированных' не проверяем фильтр по датам (BANNERSTORAGE-3098)
                WHEN @date_end IS NULL THEN 1
                WHEN @date_end IS NOT NULL AND cv.moderation_date <= DATEADD(day, 1, @date_end) THEN 1
                ELSE 0
                END
        AND 1 = CASE
                WHEN @user_id IS NOT NULL AND cv.user_id = @user_id THEN 1
                WHEN @user_id IS NULL THEN 1
                ELSE 0
                END

  END

  SELECT COUNT(*) cnt FROM @Creatives

  ;WITH Creatives AS (
    SELECT
      creative_nmb,
      creative_version_nmb,
      creative_name,
      status_nmb,
      status_name,
      customer_nmb,
      customer_name,
      is_rejected_by_automoderator,
      moderator_full_name,
      moderation_date,
      moderator_id,
      wrong_moderation_result,
        'num' = ROW_NUMBER()
      OVER (
        ORDER BY c.moderation_date DESC)
    FROM @Creatives c
  )
  SELECT TOP (@Limit)
    cc.*
  FROM Creatives cc
  WHERE cc.num > @Offset
  ORDER BY cc.num

GO
grant execute on [sp_moderation_creative_select_history] to admin_zone_role