﻿
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'sp_moderation_creative_version_check_moderation_result') AND type in (N'P', N'PC'))
drop procedure sp_moderation_creative_version_check_moderation_result
GO
/*
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'sp_moderation_creative_version_check_moderation_result') AND type in (N'P', N'PC'))
 drop procedure sp_moderation_creative_version_moderation_result
*/

CREATE PROCEDURE [dbo].sp_moderation_creative_version_check_moderation_result

    @creative_version_nmb int,
    @user_id uniqueidentifier,
    @wrong_moderation_result tinyint
    
AS
    declare @status_nmb int
    declare @is_moderated_externally bit

    select
        @status_nmb = cv.status_nmb,
        @is_moderated_externally = c.is_moderated_externally
    from t_creative_version cv (nolock)
        join t_creative c on cv.creative_nmb = c.nmb
    where cv.nmb = @creative_version_nmb

    if (@is_moderated_externally = 1)
    begin
        select 0 ok, 'Этот креатив модерируется внешней системой' res
        return
    end

    if(@status_nmb not in (3, 4))
    begin
        select 0 ok, 'Данный креатив не находится в статусе Oтмодерирован' res
        return        
    end
    
    if((select count(*)
        from vs_user u
        join vs_user_role ur on u.id = [user_id] and u.archive = 0 and ur.archive = 0
        join vs_role r on r.id = [role_id] and symbol in ('main_moder') 
        and u.id = @user_id) = 0)
    begin
        select 0 ok, 'У пользователя нет прав супер-модератора' res
        return
    end
    
    update t_creative_version set 
    wrong_moderation_result = @wrong_moderation_result
    where nmb = @creative_version_nmb
    
    select 1 ok, 'Результаты проверки сохранены' res
    return
/*
grant execute on sp_moderation_creative_version_check_moderation_result to admin_zone_role
*/
GO
grant execute on sp_moderation_creative_version_check_moderation_result to admin_zone_role