GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_creative_version_clear]') AND type in (N'P', N'PC'))
drop procedure [sp_moderation_creative_version_clear]
GO

CREATE PROCEDURE [dbo].[sp_moderation_creative_version_clear]
    @creative_version_nmb int,
    @user_id uniqueidentifier
AS
    declare @status_nmb int, @lock_user_id uniqueidentifier
    set @lock_user_id = null

    select @status_nmb = status_nmb, @lock_user_id = [user_id] 
    from vt_creative_version where nmb = @creative_version_nmb

    if(@status_nmb <> 2)
    begin
        select 0 ok, 'Данный креатив не находится в статусе неотмодерирован' res
        return        
    end

    if((select count(*)
        from vs_user u
        join vs_user_role ur on u.id = [user_id] and u.archive = 0 and ur.archive = 0
        join vs_role r on r.id = [role_id] and symbol in ('main_moder') 
        and u.id = @user_id) = 0)
    begin
        select 0 ok, 'У пользователя нет прав супер-модератора' res
        return
    end

    update t_creative_version set 
    moderation_date = null, [user_id] = null
    where nmb = @creative_version_nmb

    select 1 ok, 'Креатив разблокирован' res
    return
GO
grant execute on [sp_moderation_creative_version_clear] to admin_zone_role
