GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_creative_version_lock]') AND type in (N'P', N'PC'))
drop procedure [sp_moderation_creative_version_lock]
GO

CREATE PROCEDURE [dbo].[sp_moderation_creative_version_lock]
    @creative_version_nmb int,
    @user_id uniqueidentifier
AS
    if((select count(*)
        from vs_user u
        join vs_user_role ur on u.id = [user_id] and u.archive = 0 and ur.archive = 0
        join vs_role r on r.id = [role_id] and symbol in ('main_moder', 'moder')
        and u.id = @user_id) = 0)
    begin
        select 0 ok, 'У пользователя нет прав модератора' res
        return
    end

    declare @status_nmb int, @lock_user_id uniqueidentifier
    set @lock_user_id = null
    declare @is_moderated_externally bit
    
    select
        @status_nmb = cv.status_nmb,
        @lock_user_id = cv.[user_id],
        @is_moderated_externally = c.is_moderated_externally
    from vt_creative_version cv
        join t_creative c on cv.creative_nmb = c.nmb
    where cv.nmb = @creative_version_nmb

    if (@is_moderated_externally = 1)
    begin
        select 0 ok, 'Креатив модерируется внешней системой' res
        return
    end

    if(@status_nmb <> 2)
    begin
        select 0 ok, 'Данный креатив не находится в статусе неотмодерирован' res
        return        
    end

    if(@lock_user_id is not null)
    begin
        select 0 ok, 'У креатива уже есть модератор' res
        return
    end

    update t_creative_version set 
    lock_moderation_date = getdate(), [user_id] = @user_id
    where nmb = @creative_version_nmb

    select 1 ok, 'Креатив заблокирован' res
    return
GO
grant execute on [sp_moderation_creative_version_lock] to admin_zone_role
