if object_id('dbo.sp_moderation_creative_version_lock_by_tag') is null
    exec ('create procedure dbo.sp_moderation_creative_version_lock_by_tag as begin return end')
go
set ansi_nulls on;
set quoted_identifier on;
go

ALTER PROCEDURE [dbo].[sp_moderation_creative_version_lock_by_tag]
    @creative_tag             nvarchar(100) = null,
    @creative_group_nmb       int = null,
    @user_id                  uniqueidentifier,
    @max_lock_creative_count  int = 50
AS
BEGIN

    if @creative_tag IS NULL and @creative_group_nmb IS NULL
        begin
            select 1 error_code, 'Ошибка входных параметров' result
            return
        end

    if((select count(*)
        from vs_user u
        join vs_user_role ur on u.id = [user_id] and u.archive = 0 and ur.archive = 0
        join vs_role r on r.id = [role_id] and symbol in ('main_moder', 'moder')
        and u.id = @user_id) = 0)
    begin
        select 1 error_code, 'У пользователя нет прав модератора' result
        return
    end

    declare @cnt int = 0

    if @creative_tag IS NOT NULL BEGIN

        SET XACT_ABORT ON
        BEGIN TRAN

            UPDATE TOP (@max_lock_creative_count) cv SET
                    cv.lock_moderation_date = getdate(),
                    cv.[user_id] = @user_id
                FROM t_creative_version cv
                JOIN t_creative c ON c.nmb = cv.creative_nmb
                        AND c.tag = @creative_tag
                WHERE cv.status_nmb = 2
                    AND cv.[user_id] IS NULL
                    AND c.is_moderated_externally = 0

                SET @cnt = @@ROWCOUNT

        COMMIT TRAN

    END ELSE IF @creative_group_nmb IS NOT NULL BEGIN

        SET XACT_ABORT ON
        BEGIN TRAN

            UPDATE TOP (@max_lock_creative_count) cv SET
                cv.lock_moderation_date = getdate(),
                cv.[user_id] = @user_id
            FROM t_creative_version cv
                JOIN t_creative c ON c.nmb = cv.creative_nmb
                                                         AND c.creative_group_nmb = @creative_group_nmb
            WHERE cv.status_nmb = 2
                AND cv.[user_id] IS NULL
                AND c.is_moderated_externally = 0

            SET @cnt = @@ROWCOUNT

        COMMIT TRAN

    END

    select 0 error_code, @cnt result

    return
END
GO
grant execute on [sp_moderation_creative_version_lock] to admin_zone_role
GO
