if (OBJECT_ID('dbo.sp_moderation_creative_version_remoderate_list', 'P') is not null)
	drop procedure dbo.sp_moderation_creative_version_remoderate_list;
go

set ansi_nulls on;
go

-- перевести креатив в состояние модераци¤ или ожидает модерации из состо¤ний подтвержден (status_nmb = 4) или отклонен (status_nmb = 3)
-- подробности в dbo.sp_moderation_creative_version_remoderate_set
create procedure dbo.sp_moderation_creative_version_remoderate_list
	@creative_nmb_list varchar(max), -- формат: <creative-nmb>(;<creative-nmb>)*
	@initiator_id uniqueidentifier,
	@set_new_moderator bit = 0,
	@new_moderator_id uniqueidentifier = null
as
begin
	set xact_abort, nocount on;
	
	declare @creative_nmb_set as dbo.type_id_set;
	
	insert into @creative_nmb_set(nmb)
	select cast(str as int) as nmb
	from dbo.uf_convert_list_of_str_to_table(ltrim(rtrim(@creative_nmb_list)), ';')
	where str <> '';
	
	exec dbo.sp_moderation_creative_version_remoderate_set @creative_nmb_set, @initiator_id, @set_new_moderator, @new_moderator_id;
end;
go
