﻿if (OBJECT_ID('dbo.sp_moderation_creative_version_remoderate_set', 'P') is not null)
	drop procedure dbo.sp_moderation_creative_version_remoderate_set;
go

set ansi_nulls on;
go

-- Перевести креативы в состояния модерация или ожидает модерации из состояний подтвержден (status_nmb = 4) или отклонен (status_nmb = 3)
-- Если @set_new_moderator = 0, то креатив переводится в состояние ожидает модерации
-- Если @set_new_moderator = 1, то креатив переводится в состояние модерация и нового модератора определяет @new_moderator_id (сохраняется старый если @new_moderator_id = null)
create procedure dbo.sp_moderation_creative_version_remoderate_set
	@creative_nmb_set dbo.type_id_set readonly,
	@initiator_id uniqueidentifier,
	@set_new_moderator bit = 0,
	@new_moderator_id uniqueidentifier = null
as
begin
	set xact_abort, nocount on;
	
	-- Проверить наличие прав доступа
	exec dbo.sp_require_permissions @initiator_id, N'super-moder;admin';

	begin transaction;

	update dbo.t_creative_version
	set status_nmb = 2,
		notified = 0,
		[user_id] = (
			case
				when @set_new_moderator = 0 then null
				when @set_new_moderator = 1 and @new_moderator_id <> null then @new_moderator_id
				else [user_id]
			end
		)
	where nmb in (
		select cv.nmb from
			@creative_nmb_set as c
				cross apply
			(
				select top 1 nmb, status_nmb from dbo.t_creative_version
				where creative_nmb = c.nmb
				order by nmb desc
			) as cv
		where cv.status_nmb in (3, 4)
	);
		
	commit transaction;
end;
go

grant execute on dbo.sp_moderation_creative_version_remoderate_set to admin_zone_role
go
