GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_customer_report]') AND type in (N'P', N'PC'))
drop procedure [sp_moderation_customer_report]
GO
/*
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_moderation_customer_report]') AND type in (N'P', N'PC'))
 drop procedure sp_moderation_customer_report
*/

/*
	sp_moderation_customer_report @date_begin = '2014-02-17', @date_end = '2014-03-30'
	sp_moderation_customer_report @date_begin = '2014-02-17', @date_end = '2014-03-30', @group = 'day'
	sp_moderation_customer_report @date_begin = '2014-02-17', @date_end = '2014-03-30', @group = 'week'
	sp_moderation_customer_report @date_begin = '2014-03-04', @date_end = '2014-05-28', @group = 'mm'
	sp_moderation_customer_report @date_begin = '2014-03-04', @date_end = '2014-05-28', @group = 'yy'

*/
CREATE PROCEDURE [dbo].[sp_moderation_customer_report]

	@date_begin datetime = null,
	@date_end datetime = null,
	@group varchar(10) = null,
	@customer_nmb varchar(8000) = null,
	@include_externally_moderated int = 0
	
AS

	declare @cmd varchar(8000)

	select @date_begin = isnull(@date_begin, 0), @date_end = dateadd(day, 1, isnull(@date_end, '2999-01-01'))

	create table #customer (nmb int)
	if(@customer_nmb is not null)
	begin
			select @cmd = '
			insert into #customer select nmb from vs_customer
			where nmb in (' + @customer_nmb + ')'
			exec(@cmd)
	end	

	create table #t
	(
		day datetime,
		name varchar(100),
		nmb int,
		status_nmb_3 int,
		status_nmb_4 int
	)
	
	create table #sort (sort int)
	insert into #sort select 1
	insert into #sort select 2
	insert into #sort select 3
	
	create table #day (day datetime)
	create table #week (sun datetime, mon datetime)
	create table #mm (yy int, mm int)
	create table #yy (yy int)
	create table #dsp (nmb int, name varchar(100))
	
	-----------------------------------------------------------------------------------------------------------
	-- 
	-----------------------------------------------------------------------------------------------------------
	if(@customer_nmb is null)
		insert into #t
		select convert(varchar(10), cv.moderation_date, 21), 
		cs.name, cs.nmb,
		sum(case when status_nmb = 3 then 1 else 0 end) status_nmb_3,
		sum(case when status_nmb = 4 then 1 else 0 end) status_nmb_4
		from vt_creative_version cv
		join vt_creative c on cv.creative_nmb = c.nmb
		join c_creative_status s on cv.status_nmb = s.nmb
		join vs_customer cs on customer_nmb = cs.nmb and cs.archive = 0
		where (c.is_moderated_externally = 0 or @include_externally_moderated = 1)
            and cv.status_nmb in (3, 4)
            and	cv.moderation_date >= @date_begin
            and	cv.moderation_date <= @date_end
		group by cs.name, cs.nmb, convert(varchar(10), cv.moderation_date, 21)
	else
		insert into #t
		select convert(varchar(10), cv.moderation_date, 21), 
		cs.name, cs.nmb,
		sum(case when status_nmb = 3 then 1 else 0 end) status_nmb_3,
		sum(case when status_nmb = 4 then 1 else 0 end) status_nmb_4
		from vt_creative_version cv
		join vt_creative c on cv.creative_nmb = c.nmb
		join c_creative_status s on cv.status_nmb = s.nmb
		join vs_customer cs on customer_nmb = cs.nmb and cs.archive = 0
		join #customer cs2 on cs.nmb = cs2.nmb
		where (c.is_moderated_externally = 0 or @include_externally_moderated = 1)
		    and cv.status_nmb in (3, 4)
            and	cv.moderation_date >= @date_begin
            and	cv.moderation_date <= @date_end
		group by cs.name, cs.nmb, convert(varchar(10), cv.moderation_date, 21)		

	insert into #day select distinct day from #t
	
	insert into #week 
	select distinct 
	dateadd(dd, 8 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day) sun,
	dateadd(dd, 2 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day) mon
	from #t
	
	insert into #mm select distinct datepart(yy, day) yy, datepart(mm, day) mm from #t
	insert into #yy select distinct datepart(yy, day) yy from #t
	
	insert into #dsp select distinct nmb, name from #t
	
	-----------------------------------------------------------------------------------------------------------
	-- all
	-----------------------------------------------------------------------------------------------------------
	if(@group is null)
	begin
		select 1 sort, name, nmb, 
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		dbo.fn_translit(name) eng_name
		from #t
		where nmb <> 1
		group by name, nmb
		
		union
		
		select 2 sort, 
		'<b>Cумма по dsp без ado' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'DSP sum without ado' eng_name
		from #t
		where nmb <> 1
		
		union
		
		select 3 sort, 
		'<b>Adoffice' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'Adoffice' eng_name
		from #t
		where nmb = 1
		
		union
		
		select 4 sort, 
		'<b>Итого по всем за период' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'Sum' eng_name
		from #t
		
		order by sort, name
	end

	-----------------------------------------------------------------------------------------------------------
	-- По дням
	-----------------------------------------------------------------------------------------------------------
	if(@group = 'day')
	begin
		-----------------------------------------------------------------------------------------------------------
		-- для 2й таблицы
		-----------------------------------------------------------------------------------------------------------
		select 1 sort, day, nmb, name, status_nmb_4 cnt
		into #t2
		from #t
		
		insert into #t2
		select 2 sort, day, nmb, name, status_nmb_3 cnt
		from #t
		
		insert into #t2
		select 3 sort, day, nmb, name, status_nmb_4 + status_nmb_3 cnt
		from #t
		
		select s.sort, c.name, c.nmb, d.day, 
		isnull(cnt, 0) cnt
		into #t3
		from #sort s
		join #day d on 1 = 1
		join #dsp c on 1 = 1
		left join #t2 t on t.sort = s.sort and t.day = d.day and t.nmb = c.nmb
		
		-----------------------------------------------------------------------------------------------------------
		-- вывод 1й таблицы
		-----------------------------------------------------------------------------------------------------------
		select 1 sort, *,
		status_nmb_3 + status_nmb_4 cnt,
		dbo.fn_translit(name) eng_name
		from #t
		where nmb <> 1
		
		union
		
		select 2 sort, 
		day day,
		'<b>Cумма по dsp без ado' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'DSP sum without ado' eng_name
		from #t
		where nmb <> 1
		group by day
		
		union
		
		select 3 sort, 
		day day,
		'<b>Adoffice' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'Adoffice' eng_name
		from #t
		where nmb = 1
		group by day
		
		union
		
		select 4 sort, 
		day,
		'<b>Итого по всем за период' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'Sum' eng_name
		from #t
		group by day
		
		order by day, sort, name
		
		-----------------------------------------------------------------------------------------------------------
		-- вывод 2й таблицы
		-----------------------------------------------------------------------------------------------------------
		select * from #day order by day

		select 1 sort1, 1 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, day, sum(cnt) cnt 
		from #t3
		where sort = 1 and nmb <> 1
		group by day
		
		union
		
		select 2 sort1, 2 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, day, sum(cnt) cnt 
		from #t3
		where sort = 2 and nmb <> 1
		group by day
		
		union
		
		select 3 sort1, 3 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, day, sum(cnt) cnt 
		from #t3
		where sort = 3 and nmb <> 1
		group by day

		union

		select 4 sort1, sort, name, dbo.fn_translit(name) eng_name, day, cnt
		from #t3
		where nmb = 1

		union

		select 5 sort1, sort, name, dbo.fn_translit(name) eng_name, day, cnt
		from #t3
		where nmb <> 1
		
		union
		
		select 6 sort1, 1 sort, '<B>Итого' name, '<B>ALL' eng_name, day, sum(cnt) cnt 
		from #t3
		where sort = 1
		group by day
		
		union
		
		select 7 sort1, 2 sort, '<B>Итого' name, '<B>ALL' eng_name, day, sum(cnt) cnt 
		from #t3
		where sort = 2
		group by day
		
		union
		
		select 8 sort1, 3 sort, '<B>Итого' name, '<B>ALL' eng_name, day, sum(cnt) cnt 
		from #t3
		where sort = 3
		group by day
		order by sort1, name, sort, day
	end

	-----------------------------------------------------------------------------------------------------------
	-- По неделям
	-----------------------------------------------------------------------------------------------------------
	if(@group = 'week')
	begin
		-----------------------------------------------------------------------------------------------------------
		-- для 1 таблицы
		-----------------------------------------------------------------------------------------------------------
		select 
		dateadd(dd, 8 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day) sun,
		dateadd(dd, 2 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day) mon,
		name,
		nmb,
		sum(status_nmb_3) status_nmb_3,
		sum(status_nmb_4) status_nmb_4
		into #t_week
		from #t
		group by 
		name,
		nmb,
		dateadd(dd, 8 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day),
		dateadd(dd, 2 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day)
	
		-----------------------------------------------------------------------------------------------------------
		-- для 2й таблицы
		-----------------------------------------------------------------------------------------------------------
		select 1 sort, 
		dateadd(dd, 8 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day) sun,
		dateadd(dd, 2 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day) mon,
		nmb, name, 
		sum(status_nmb_4) cnt
		into #t2_week
		from #t
		group by dateadd(dd, 8 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day),
		dateadd(dd, 2 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day),
		nmb, name
		
		insert into #t2_week
		select 2 sort, 
		dateadd(dd, 8 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day) sun,
		dateadd(dd, 2 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day) mon,
		nmb, name, 
		sum(status_nmb_3) cnt
		from #t
		group by dateadd(dd, 8 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day),
		dateadd(dd, 2 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day),
		nmb, name
		
		insert into #t2_week
		select 3 sort, 
		dateadd(dd, 8 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day) sun,
		dateadd(dd, 2 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day) mon,
		nmb, name, 
		sum(status_nmb_4 + status_nmb_3) cnt
		from #t
		group by dateadd(dd, 8 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day),
		dateadd(dd, 2 - case when datepart(dw, day) > 1 then datepart(dw, day) else 8 end, day),
		nmb, name
		
		select s.sort, c.name, c.nmb, w.sun, w.mon,
		isnull(cnt, 0) cnt
		into #t3_week
		from #sort s
		join #week w on 1 = 1
		join #dsp c on 1 = 1
		left join #t2_week t on t.sort = s.sort and t.sun = w.sun and t.nmb = c.nmb
		order by c.name, s.sort, w.sun, w.mon
	
		-----------------------------------------------------------------------------------------------------------
		-- вывод 1й таблицы
		-----------------------------------------------------------------------------------------------------------
		select 1 sort, *,
		status_nmb_3 + status_nmb_4 cnt,
		dbo.fn_translit(name) eng_name 
		from #t_week
		where nmb <> 1
		
		union
		
		select 2 sort, 
		sun, mon, 
		'<b>Cумма по dsp без ado' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'DSP sum without ado' eng_name
		from #t_week
		where nmb <> 1
		group by mon, sun
		
		union
		
		select 3 sort, 
		sun, mon, 
		'<b>Adoffice' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'Adoffice' eng_name
		from #t_week
		where nmb = 1
		group by mon, sun
		
		union
		
		select 4 sort, 
		sun, mon, 
		'<b>Итого по всем за период' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'Sum' eng_name
		from #t_week
		group by mon, sun
		
		order by mon, sort, name
		
		-----------------------------------------------------------------------------------------------------------
		-- вывод 2й таблицы
		-----------------------------------------------------------------------------------------------------------
		select * from #week order by sun

		select 1 sort1, 1 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, sun, mon, sum(cnt) cnt 
		from #t3_week
		where sort = 1 and nmb <> 1
		group by sun, mon
		
		union
		
		select 2 sort1, 2 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, sun, mon, sum(cnt) cnt 
		from #t3_week
		where sort = 2 and nmb <> 1
		group by sun, mon
		
		union
		
		select 3 sort1, 3 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, sun, mon, sum(cnt) cnt 
		from #t3_week
		where sort = 3 and nmb <> 1
		group by sun, mon
		
		union

		select 4 sort1, sort, name, dbo.fn_translit(name) eng_name, sun, mon, cnt
		from #t3_week
		where nmb = 1
		
		union

		select 5 sort1, sort, name, dbo.fn_translit(name) eng_name, sun, mon, cnt
		from #t3_week
		where nmb <> 1
		
		union
		
		select 6 sort1, 1 sort, '<B>Итого' name, 'ALL' eng_name, sun, mon, sum(cnt) cnt 
		from #t3_week
		where sort = 1
		group by sun, mon
		
		union
		
		select 7 sort1, 2 sort, '<B>Итого' name, 'ALL' eng_name, sun, mon, sum(cnt) cnt 
		from #t3_week
		where sort = 2
		group by sun, mon
		
		union
		
		select 8 sort1, 3 sort, '<B>Итого' name, 'ALL' eng_name, sun, mon, sum(cnt) cnt 
		from #t3_week
		where sort = 3
		group by sun, mon
		order by sort1, name, sort, sun
	end

	-----------------------------------------------------------------------------------------------------------
	-- По месяцам
	-----------------------------------------------------------------------------------------------------------
	if(@group = 'mm')
	begin
		-----------------------------------------------------------------------------------------------------------
		-- для 1й таблицы
		-----------------------------------------------------------------------------------------------------------
		select 
		datepart(yy, day) yy,
		datepart(mm, day) mm,
		name,
		nmb,
		sum(status_nmb_3) status_nmb_3,
		sum(status_nmb_4) status_nmb_4
		into #t_mm
		from #t
		group by 
		name,
		nmb,
		datepart(yy, day),
		datepart(mm, day)

		-----------------------------------------------------------------------------------------------------------
		-- для 2й таблицы
		-----------------------------------------------------------------------------------------------------------
		select 1 sort, 
		datepart(yy, day) yy, datepart(mm, day) mm,
		nmb, name, 
		sum(status_nmb_4) cnt
		into #t2_mm
		from #t
		group by datepart(yy, day), datepart(mm, day), nmb, name
		
		insert into #t2_mm
		select 2 sort, 
		datepart(yy, day) yy, datepart(mm, day) mm,
		nmb, name, 
		sum(status_nmb_3) cnt
		from #t
		group by datepart(yy, day), datepart(mm, day), nmb, name
		
		insert into #t2_mm
		select 3 sort, 
		datepart(yy, day) yy, datepart(mm, day) mm,
		nmb, name, 
		sum(status_nmb_4 + status_nmb_3) cnt
		from #t
		group by datepart(yy, day), datepart(mm, day), nmb, name
		
		select s.sort, c.name, c.nmb, m.mm, m.yy,
		isnull(cnt, 0) cnt
		into #t3_mm
		from #sort s
		join #mm m on 1 = 1
		join #dsp c on 1 = 1
		left join #t2_mm t on t.sort = s.sort and t.yy = m.yy and t.mm = m.mm and t.nmb = c.nmb
		order by c.name, s.sort, m.yy, m.mm

		-----------------------------------------------------------------------------------------------------------
		-- вывод 1й таблицы
		-----------------------------------------------------------------------------------------------------------
		select 1 sort, *,
		status_nmb_3 + status_nmb_4 cnt,
		dbo.fn_translit(name) eng_name 
		from #t_mm
		where nmb <> 1
		
		union
		
		select 2 sort, 
		yy, mm,
		'<b>Cумма по dsp без ado' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'DSP sum without ado' eng_name
		from #t_mm
		where nmb <> 1
		group by yy, mm
		
		union
		
		select 3 sort, 
		yy, mm,
		'<b>Adoffice' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'Adoffice' eng_name
		from #t_mm
		where nmb = 1
		group by yy, mm
		
		union
		
		select 4 sort, 
		yy, mm,
		'<b>Итого по всем за период' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'Sum' eng_name
		from #t_mm
		group by yy, mm
		
		order by yy, mm, sort, name
		
		-----------------------------------------------------------------------------------------------------------
		-- вывод 2й таблицы
		-----------------------------------------------------------------------------------------------------------
		select * from #mm order by yy, mm
		
		select 1 sort1, 1 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, mm, yy, sum(cnt) cnt 
		from #t3_mm
		where sort = 1 and nmb <> 1
		group by yy, mm
		
		union
		
		select 2 sort1, 2 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, mm, yy, sum(cnt) cnt 
		from #t3_mm
		where sort = 2 and nmb <> 1
		group by yy, mm 
		
		union
		
		select 3 sort1, 3 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, mm, yy, sum(cnt) cnt 
		from #t3_mm
		where sort = 3 and nmb <> 1
		group by yy, mm 
		
		union

		select 4 sort1, sort, name, dbo.fn_translit(name) eng_name, mm, yy, cnt
		from #t3_mm
		where nmb = 1
			
		union

		select 5 sort1, sort, name, dbo.fn_translit(name) eng_name, mm, yy, cnt
		from #t3_mm
		where nmb <> 1
		
		union
		
		select 6 sort1, 1 sort, '<B>Итого' name, 'ALL' eng_name, mm, yy, sum(cnt) cnt 
		from #t3_mm
		where sort = 1
		group by yy, mm
		
		union
		
		select 7 sort1, 2 sort, '<B>Итого' name, 'ALL' eng_name, mm, yy, sum(cnt) cnt 
		from #t3_mm
		where sort = 2
		group by yy, mm
		
		union
		
		select 8 sort1, 3 sort, '<B>Итого' name, 'ALL' eng_name, mm, yy, sum(cnt) cnt 
		from #t3_mm
		where sort = 3
		group by yy, mm
		order by sort1, name, sort, yy, mm
	end

	-----------------------------------------------------------------------------------------------------------
	-- По годам
	-----------------------------------------------------------------------------------------------------------
	if(@group = 'yy')
	begin
		-----------------------------------------------------------------------------------------------------------
		-- для 1й таблицы
		-----------------------------------------------------------------------------------------------------------
		select 
		datepart(yy, day) yy,
		name,
		nmb,
		sum(status_nmb_3) status_nmb_3,
		sum(status_nmb_4) status_nmb_4
		into #t_yy
		from #t
		group by 
		name,
		nmb,
		datepart(yy, day)

		-----------------------------------------------------------------------------------------------------------
		-- для 2й таблицы
		-----------------------------------------------------------------------------------------------------------
		select 1 sort, 
		datepart(yy, day) yy,
		nmb, name, 
		sum(status_nmb_4) cnt
		into #t2_yy
		from #t
		group by datepart(yy, day), nmb, name
		
		insert into #t2_yy
		select 2 sort, 
		datepart(yy, day) yy,
		nmb, name, 
		sum(status_nmb_3) cnt
		from #t
		group by datepart(yy, day), nmb, name
		
		insert into #t2_yy
		select 3 sort, 
		datepart(yy, day) yy, 
		nmb, name, 
		sum(status_nmb_4 + status_nmb_3) cnt
		from #t
		group by datepart(yy, day), nmb, name
		
		select s.sort, c.name, c.nmb, m.yy,
		isnull(cnt, 0) cnt
		into #t3_yy
		from #sort s
		join #yy m on 1 = 1
		join #dsp c on 1 = 1
		left join #t2_yy t on t.sort = s.sort and t.yy = m.yy and t.nmb = c.nmb
		order by c.name, s.sort, m.yy

		-----------------------------------------------------------------------------------------------------------
		-- вывод 1й таблицы
		-----------------------------------------------------------------------------------------------------------
		select 1 sort, *,
		status_nmb_3 + status_nmb_4 cnt,
		dbo.fn_translit(name) eng_name 
		from #t_yy
		where nmb <> 1
		
		union
		
		select 2 sort, 
		yy,
		'<b>Cумма по dsp без ado' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'DSP sum without ado' eng_name
		from #t_yy
		where nmb <> 1
		group by yy
		
		union
		
		select 3 sort, 
		yy,
		'<b>Adoffice' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'Adoffice' eng_name
		from #t_yy
		where nmb = 1
		group by yy
		
		union
		
		select 4 sort, 
		yy,
		'<b>Итого по всем за период' name, 0 nmb,
		SUM(status_nmb_3) status_nmb_3,
		SUM(status_nmb_4) status_nmb_4,
		SUM(status_nmb_3 + status_nmb_4) cnt,
		'Sum' eng_name
		from #t_yy
		group by yy
		
		order by yy, sort, name
		
		-----------------------------------------------------------------------------------------------------------
		-- вывод 2й таблицы
		-----------------------------------------------------------------------------------------------------------
		select * from #yy order by yy

		select 1 sort1, 1 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, yy, sum(cnt) cnt 
		from #t3_yy
		where sort = 1 and nmb <> 1
		group by yy
		
		union
		
		select 2 sort1, 2 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, yy, sum(cnt) cnt 
		from #t3_yy
		where sort = 2 and nmb <> 1
		group by yy
		
		union
		
		select 3 sort1, 3 sort, '<B>Cумма по dsp без ado' name, 'DSP sum without ado' eng_name, yy, sum(cnt) cnt 
		from #t3_yy
		where sort = 3 and nmb <> 1
		group by yy
		
		union
		
		select 4 sort1, sort, name, dbo.fn_translit(name) eng_name, yy, cnt
		from #t3_yy
		where nmb = 1
		
		union
		
		select 5 sort1, sort, name, dbo.fn_translit(name) eng_name, yy, cnt
		from #t3_yy
		where nmb <> 1
		
		union
		
		select 6 sort1, 1 sort, '<B>Итого' name, 'ALL' eng_name, yy, sum(cnt) cnt 
		from #t3_yy
		where sort = 1
		group by yy
		
		union
		
		select 7 sort1, 2 sort, '<B>Итого' name, 'ALL' eng_name, yy, sum(cnt) cnt 
		from #t3_yy
		where sort = 2
		group by yy
		
		union
		
		select 8 sort1, 3 sort, '<B>Итого' name, 'ALL' eng_name, yy, sum(cnt) cnt 
		from #t3_yy
		where sort = 3
		group by yy
		order by sort1, name, sort, yy
	end

	drop table #t
	
/*
grant execute on [sp_moderation_customer_report] to admin_zone_role
*/
GO
grant execute on [sp_moderation_customer_report] to admin_zone_role