GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'sp_reason_stat_') AND type in (N'P', N'PC'))
drop procedure sp_reason_stat_
GO

-- sp_reason_stat_ @date_begin = '2014-04-01', @date_end = '2014-04-01'  
/*
sp_reason_stat_ 'select_reason', @user_id = '8F071C78-929A-4546-8CCD-708DA175B820', 
@date_begin = '2012-01-01', @date_end = '2013-01-29',
@reason_id = 'D16EB41A-D0B0-4D3D-9255-BB5E060CEC07'
*/
CREATE PROCEDURE [dbo].sp_reason_stat_

	@mode varchar(50) = 'select_all',
	
	@date_begin datetime = null,
	@date_end datetime = null,
	@user_id uniqueidentifier = null,
	@reason_id uniqueidentifier = null 

AS

	select @date_begin = isnull(@date_begin, 0), 
	@date_end = dateadd(day, 1, isnull(@date_end, '2999-01-01'))
	
	if(@mode = 'select_reason')
	begin
		select cml.nmb creative_version_nmb, cml.creative_nmb, wrong_moderation_result, moderation_date
		from vt_creative_version cml
		join vr_creative_version_reason c on creative_version_nmb = cml.nmb and c.archive = 0
		where @date_begin <= moderation_date and moderation_date <= @date_end 
		and [user_id] = isnull(@user_id, [user_id])
		and reason_id = @reason_id

		return
	end
	
	if(@mode = 'select_all')
	begin
		create table #u (user_id uniqueidentifier, full_name varchar(300))

		insert into #u
		select distinct u.id, full_name
		from vs_user u
		join vs_user_role ur on [user_id] = u.id  and ur.archive = 0
		join vs_role r on role_id = r.id
		where u.id = isnull(@user_id, u.id)
		and symbol in ('moder', 'main_moder')

		select reason_id, u.[user_id], 
		count(cml.creative_nmb) cnt, 
		sum(case when wrong_moderation_result = 1 then 1 else 0 end) wrong_cnt
		into #res0
		from vt_creative_version cml
		join #u u on cml.[user_id] = u.[user_id]
		join vr_creative_version_reason c on creative_version_nmb = cml.nmb and c.archive = 0
		where @date_begin <= moderation_date and moderation_date <= @date_end 
		and status_nmb in (3, 4)
		group by reason_id, u.[user_id]
	
		select rs.id, rs.nmb, rs.name, rs.moderator_name, u.*, cnt, wrong_cnt
		into #res1
		from
		(
			select distinct reason_id, u.[user_id]
			from #res0 r
			full join #u u on 1 = 1
		) r
		join vd_reason rs on r.reason_id = rs.id
		left join #res0 r0 on r.reason_id = r0.reason_id and r0.[user_id] = r.[user_id]
		left join #u u on u.[user_id] = r.[user_id]


		-------------------------------------------------------------
		-- заголовок
		-------------------------------------------------------------
		insert into #res1
		select newid(), -1, '', '', *, 0, 0
		from #u

		-------------------------------------------------------------
		-- принятые / отклоненные креативы
		-------------------------------------------------------------
		select [user_id], 
		sum(case when has_reason > 0 then 1 else 0 end) not_ok,
		sum(case when has_reason = 0 then 1 else 0 end) ok,
		sum(case when has_reason > 0 and wrong_moderation_result = 1 then 1 else 0 end) wrong_not_ok,
		sum(case when has_reason = 0 and wrong_moderation_result = 1 then 1 else 0 end) wrong_ok
		into #res2
		from
		(
			select cml.nmb, cml.creative_nmb, cml.[user_id], wrong_moderation_result,
			sum(case when c.id is null then 0 else 1 end) has_reason
			from vt_creative_version cml
			join #u u on cml.[user_id] = u.[user_id]
			left join vr_creative_version_reason c on creative_version_nmb = cml.nmb and c.archive = 0
			where @date_begin <= moderation_date and moderation_date <= @date_end
			and status_nmb in (3, 4)
			group by cml.nmb, cml.creative_nmb, cml.[user_id], wrong_moderation_result
		) t
		group by [user_id]

		select u.*, ok, not_ok, wrong_ok, wrong_not_ok
		into #res3 
		from #u u
		left join #res2 r on u.[user_id] = r.[user_id]

		insert into #res1
		select newid() id, 0 nmb, 'Принято', 'Принято', [user_id], full_name, ok cnt, wrong_ok wrong_cnt from #res3

		insert into #res1
		select newid() id, 1 nmb, 'Отклонено', 'Отклонено', [user_id], full_name, not_ok cnt, wrong_not_ok wrong_cnt from #res3

		-------------------------------------------------------------
		-- результат
		-------------------------------------------------------------
		SELECT
			r.id,
			r.nmb,
			r.name,
			r.moderator_name,
			r.user_id,
			r.full_name,
			r.cnt,
			r.wrong_cnt,
			dbo.SumString(o.name, ', ') reason_object
		FROM #res1 r
			LEFT JOIN dbo.vd_reason rs ON rs.id = r.id
			LEFT JOIN dbo.r_reason_object ro ON ro.reason_nmb = rs.nmb AND ro.archive = 0
			LEFT JOIN dbo.vc_reason_object o ON o.nmb = ro.object_nmb and o.archive = 0
		GROUP BY r.id, r.nmb, r.name, r.moderator_name, r.user_id, r.full_name,r.cnt, r.wrong_cnt
		ORDER BY r.nmb, r.name, full_name

		return
	end

GO
grant execute on sp_reason_stat_ to admin_zone_role