SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_site_]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_site_]
GO

/*
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[sp_site_]') AND type in (N'P', N'PC'))
 drop procedure sp_site_
*/

CREATE PROCEDURE [dbo].[sp_site_]

	@mode varchar(50) = 'select_all',

	@id uniqueidentifier = null,
	@nmb int = null,
	@red_color tinyint = null,
	@part varchar(100) = null


AS

	-----------------------------------------------------------------------------------------------------------
	-- select_all
	-- sp_site_ 'select_all'
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select_all')
	begin
		select *
		from vd_site bs
		order by [name]

		return
	end


	-----------------------------------------------------------------------------------------------------------
	-- change
	-- sp_site_ 'change', @nmb = 82834, @red_color = 1 
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'change')
	begin
		update d_site set red_color = isnull(@red_color, red_color) where nmb = @nmb 

		return
	end


	-----------------------------------------------------------------------------------------------------------
	-- select_like
	-- sp_site_ 'select_like', @part = 'day'
	-----------------------------------------------------------------------------------------------------------
	if(@mode = 'select_like')
	begin
		select top 10 *
		from vd_site
		where name like '%' + @part + '%'
		return
	end


/*
grant execute on [sp_site_] to admin_zone_role
*/
GO
GRANT EXECUTE ON [dbo].[sp_site_] TO [admin_zone_role]
GO
