#!/usr/bin/env python
# -*- coding: UTF-8 -*-

# Скрипт выполняет SQL запросы на ppc* в проде для рассчета разной статистики
# по клиентам подключившим функцию "Порог отключения" (Автоовердрафт), результаты работы запросов складывает в графит.
#
# Cкрипт запускается на 'ppcdev3' из крона
#*/30 * * * * /usr/bin/python /home/aliho/test/autooverdraft_sql_to_graphite.py >> /home/aliho/test/autooverdraft_sql_to_graphite.log

import json
import socket
import logging
import subprocess as sp

from functools import partial
from datetime import datetime
from calendar import timegm

PREFIX = 'one_min.direct.stats_v1'

graphite_host = 'localhost'
graphite_port = 42000
cmd_sql = '/usr/local/bin/direct-sql'
ppc = 'pr:ppc:all -B'

daterange = "yesterday()"   # could be today(), yesterday() or plane quoted date '2016-12-19'

def netcat(hostname, port, content):
	s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
	s.connect((hostname, port))
	s.sendall(content)
	logging.info("Sent: %s", content)
	s.shutdown(socket.SHUT_WR)
	while 1:
		data = s.recv(1024)
		if data == "":
			break
		logging.info("Received: %s", repr(data))
	s.close()

queries = {
	# сумма денег по всем овердрафтам
	'autooverdraft.clients_options.overdraft_lim.sum': 'select c.work_currency as currency, sum(co.overdraft_lim) as cnt from clients_options as co join clients as c on c.ClientID = co.ClientID where co.auto_overdraft_lim > 0 group by c.work_currency',
	# сумма денег по Порогу
	'autooverdraft.clients_options.auto_overdraft_lim.sum': 'select c.work_currency as currency, sum(co.auto_overdraft_lim) as cnt from clients_options as co join clients as c on c.ClientID = co.ClientID where co.auto_overdraft_lim > 0 group by c.work_currency',
	# сумма денег по долгам
	'autooverdraft.clients_options.debt.sum': 'select c.work_currency as currency, sum(co.debt) as cnt from clients_options as co join clients as c on c.ClientID = co.ClientID where co.auto_overdraft_lim > 0 group by c.work_currency',
	# кол-во клиентов подключивших порог
	'autooverdraft.clients_options.client_id.cnt': 'select c.work_currency as currency, count(distinct co.ClientID) as cnt from clients_options as co join clients as c on c.ClientID = co.ClientID where co.auto_overdraft_lim > 0 group by c.work_currency',
    # кол-во клиентов которые сейчас в минусе (агрегированный минус по всем клиентам, которые в минусе сейчас - отрицательное число)
    'autooverdraft.clients.sum.current.minus': 'select currency, count(distinct ClientID) as cnt from (select a.ClientID, a.currency, a.wallet_cid, (sum(cp.sum - cp.sum_spent) + a.sum) as total from (select w.ClientID as ClientID, w.currency as currency, w.cid as wallet_cid, w.sum as sum from campaigns as w where w.type = \'wallet\' and w.ClientID in (select ClientID from clients_options where auto_overdraft_lim > 0) and w.AgencyID = 0) as a join campaigns as cp on cp.wallet_cid = a.wallet_cid group by a.ClientID, a.currency, a.wallet_cid, a.sum) as b where total < 0 group by currency',
    # суммарное использование порога (агрегированный минус по всем клиентам которые в минусе - отрицательное число)
    'autooverdraft.sum.current.minus': 'select currency, -1*sum(total) as total from (select a.ClientID, a.currency, a.wallet_cid, (sum(cp.sum - cp.sum_spent) + a.sum) as total from (select w.ClientID as ClientID, w.currency as currency, w.cid as wallet_cid, w.sum as sum from campaigns as w where w.type = \'wallet\' and w.ClientID in (select ClientID from clients_options where auto_overdraft_lim > 0) and w.AgencyID = 0) as a join campaigns as cp on cp.wallet_cid = a.wallet_cid group by a.ClientID, a.currency, a.wallet_cid, a.sum) as b where total < 0 group by currency',
}

if __name__ == '__main__':
	logFormat = u'[%(asctime)s pid: %(process)d. %(threadName)s] %(filename)s:%(lineno)d %(levelname)s: %(message)s'
	logging.basicConfig(level=logging.DEBUG, format=logFormat)

	nc = partial(netcat, graphite_host, graphite_port)
	tm = datetime.now().strftime("%s")

	for prefix, sql_quiery in queries.items():
		cmd = '{cmd_sql} {ppc} "{query}"'.format(cmd_sql=cmd_sql, ppc=ppc, query=sql_quiery)
		out = sp.check_output(cmd, shell=True)
		i = 0
		for val in out.splitlines():
			if i == 0:
				i += 1
				continue
			key, value = val.split("\t")
			ppc_nmb = 'ppc' + str(i);
			nc("{}.{}.{}.{} {} {}".format(PREFIX, prefix, ppc_nmb, key, value, tm))
			i += 1
