#!/bin/bash

# Имя топика нужно вводить без префикса direct/../ess
# Документация по созданию, удалению итд https://logbroker.yandex-team.ru/docs/how_to/configuration/
set -e

[ $# -ne 2 ] && { echo "Usage: $0 [devtest|dev7|testing|prod] <topic>"; exit 1; }

CONSUMER_LIST=()
CMD="lbkx"
if [[ "$1" == "prod" ]]; then
    LOGBROKER_PATH="direct"
    TVM_ID_LIST_FOR_READ=(2009823 2000389)
    TVM_ID_LIST_FOR_WRITE=(2009823)
    CONSUMER_LIST+=("direct/direct-logshatter")
    CONSUMER_LIST+=("direct/direct-logshatter2")
else
    LOGBROKER_PATH="direct-np/$1"
    TVM_ID_LIST_FOR_READ=(2009825 2000767)
    TVM_ID_LIST_FOR_WRITE=(2009825)
fi
LOGBROKER_PATH="$LOGBROKER_PATH/ess"
TOPIC="$LOGBROKER_PATH/$2"
CONSUMER_LIST+=("$LOGBROKER_PATH/ess-consumer")

# create topic if not exists
logbroker -s $CMD schema list $LOGBROKER_PATH | if grep -ow $2 &> /dev/null;
then
    echo "Topic $2 already exists"
else
    echo yes | logbroker -s $CMD schema create topic $TOPIC -p 21 --allow-unauthenticated-write false --allow-unauthenticated-read false
fi

TOPIC_DESCRIPTION=$(logbroker -s $CMD schema describe $TOPIC)

# create read-rules if not exists
for CONSUMER in ${CONSUMER_LIST[@]}; do
    echo $TOPIC_DESCRIPTION | grep -w $CONSUMER | if grep -ow "all original" &> /dev/null;
    then
        echo "Read rule all original for topic $TOPIC and consumer $CONSUMER already exists"
    else
        echo yes | logbroker -s $CMD schema create read-rule --topic $TOPIC --consumer $CONSUMER --all-original
    fi;
done

for TVM_ID in ${TVM_ID_LIST_FOR_READ[@]}; do
    #create read permissions
    echo yes | logbroker -s $CMD permissions grant --path $TOPIC --subject $TVM_ID@tvm --permissions ReadTopic
done
for TVM_ID in ${TVM_ID_LIST_FOR_WRITE[@]}; do
    #create write permissions
    echo yes | logbroker -s $CMD permissions grant --path $TOPIC --subject $TVM_ID@tvm --permissions WriteTopic
done
