#!/bin/bash

# ЭТОТ СКРИПТ ИСПОЛЬЗОВАТЬ НЕ СТОИТ
#
# Если кратко, от этого много проблем.
#
# Если ты заметил незакоммиченную пустую директорию, создай и закоммить.
# Перед этим лучше пообщаться с владельцем/коммитером в родительскую
# директорию, чтобы уменьшить вероятность tree-conflicts в svn.
#
# Если ты используешь этот скрипт не напрямую, а в составе альясов отсюда 
# https://wiki.yandex-team.ru/Direkt/Development/Java/Setup/#propisatudobnyealiasy
# обнови альясы или вручную удали из них вызовы этого скрипта.
#
# Теперь подробно:
#
# Исходная проблема: при разработке нового модуля несколько директорий часто
# оказываются пустыми, чаще всего это src/test/resources/. Примерно
# так же часто люди забывают закоммитить пустые директории, например,
# потому что в IDEA они не отображаются.
#
# О забытой директории не предупредят ни rb ни ci, а кто-то, сделав
# svn up и получив новый модуль с забытой пустой директорией, при попытке
# собрать проект получит сообщение об ошибке.
# 
# Решение простое: пусть пустые директории отсутствуют в репозитории,
# мы будем создавать их локально в рабочей копии. Для этого был создан
# create_missed_directories.sh
#
# Со временем всплыл ряд недостатков:
# 
# 1. Если кто-то забыл закоммитить пустую директорию, а ты создал
#    ее с помощью этого скрипта, то позже, когда автор добавит в
#    директорию файлы и закоммитит ее, ты получишь tree-conflict
#    при svn up. Бесполезная трата времени и нервов на ровном месте.
#
# 2. При использовании hg этот скрипт менее эффективен, потому что
#    при переключении между бранчами пустые директории могут исчезать,
#    приходится запускать его чаще.
#
# 3. Для цели с отсутствующей директорией нельзя сделать простой
#    ya clone && ya make --checkout <target> (полезно, например,
#    для сборки модуля из чистого чекаута), сборка упадет с ошибкой.
#    Можно использовать опцию -keep-going, но она не совсем для этого
#    предназначена, плюс про нее не все знают.
#
# 4. Скрипт сложно сделать универсальным. Есть модули, выбивающиеся из
#    общей картины. Один пример - apps/user-action-log/writer, три уровня
#    вложенности директорий от корня, а скрипт умеет только два. Еще
#    один пример - libs/python, который не является java-модулем и в
#    нем не нужно создавать стандатный скелет java-модуля. Кроме того,
#    При селективном чекауте скрипт может работать некорректно, например,
#    если селективный чекаут не затронул jobs, то glob match сработает
#    неверно и в jobs будет создана папка с именем '*' с соответствующей
#    иерархией.
#
# Поэтому правильней всё же коммитить пустые директории. К сожалению,
# нет надежного способа предотвратить проблему до попадания кода в транк.
#
# В транке о проблеме сообщит собственный ci Директа -
# jenkins-new.qart.yandex-team.ru, потому что он запускает ya make без
# опции --keep-going. Но он сообщит только об отсутствующих директориях.
# Если директория присутствует, но при этом пустая, то у пользователей
# hg с ней все равно будут проблемы, потому что в hg отслеживаются
# только файлы, а не директории, другими словами, в hg пустых директорий
# не бывает.
#
# Но все же немного соломки положить можно: для создания новых модулей
# нужно использовать direct/bin/create_library.sh, который создает
# плейсхолдеры во всех пустых директориях скелета. Плейсхолдеры делают
# директории более заметными в IDEA и в hg, это существенно уменьшает
# шансы забыть их закоммитить.

DIRECT_DIR=`dirname $0`/..

for d in $DIRECT_DIR/libs/*/ $DIRECT_DIR/apps/*/ $DIRECT_DIR/jobs; do 
    for dir in $d/src/{main,test}/{java,resources}; do
	if [ ! -d "$dir" ]; then
	    echo "Creating directory: $dir"
	    mkdir -p "$dir"
	fi
    done;
done

echo "*******" >&2
echo "WARNING! $0 is deprecated. 'cat $0' for details." >&2
echo "*******" >&2
