#!/usr/bin/python
# -*- coding: utf-8 -*-

# Скрипт выполняет YQL запросы на кластерах HAHN/ARNOLD для рассчета разной статистики
# по комисси по доменам (DIRECT-87395), результаты работы запросов складывает в графит.
#
# Cкрипт запускается на 'ppcdev3' из крона
#*/30 * * * * /usr/bin/python /home/aliho/test/domain_yql_to_graphite.py >> /home/aliho/test/domain_yql_to_graphite.log

import os
import datetime
import json
import socket
import logging
import subprocess as sp

from yql.api.v1.client import YqlClient

from functools import partial
from datetime import datetime
from calendar import timegm

PREFIX = 'junk.aliho.direct.domains'
YQL_TOKEN = '/etc/direct-tokens/yql_robot-direct-yt-test'

graphite_host = 'localhost' # 'ppcdev2.yandex.ru'
graphite_port = 42000       # 7089

def netcat(hostname, port, content):
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    s.connect((hostname, port))
    s.sendall(content)
    logging.info("Sent: %s", content)
    s.shutdown(socket.SHUT_WR)
    while 1:
        data = s.recv(1024)
        if data == "":
            break
        logging.info("Received: %s", repr(data))
    s.close()

dbs = ['hahn', 'arnold']

QUERY = u'''
$yesturday = DateTime::ToSeconds(CurrentUtcDatetime() - Interval("P1D"));

$direct = (
    select
        'direct' as sistem,
        ServiceID,
        cast(count(*) as int64) as cnt,
        cast(COALESCE(count_if(isBlackDomain == 1), 0) as int64) as cntBlackList,
        cast(COALESCE(count_if(isGrayDomain == 1), 0) as int64) as cntGrayList,
        cast(COALESCE(count_if(isTechDomain == 1), 0) as int64) as cntTechList,
        sum(Cost) / 1000 / 1000 * 30.0 as sumCost,
        COALESCE(sum_if(Cost, isBlackDomain == 1), 0) / 1000 / 1000 * 30.0 as sumCostBlackList,
        COALESCE(sum_if(Cost, isGrayDomain == 1), 0) / 1000 / 1000 * 30.0 as sumCostGrayList,
        COALESCE(sum_if(Cost, isTechDomain == 1), 0) / 1000 / 1000 * 30.0 as sumCostTechList,
        cast(count(distinct Domain) as int64) as cntDomain
    from `//home/direct/export/balance/BillingOrderDomains`
    where EventDate = $yesturday
    group by ServiceID
    union all
    select
        'bk' as sistem,
        ServiceID,
        cast( count(*) as int64) as cnt,
        cast(0 as int64) as cntBlackList,
        cast(0 as int64) as cntGrayList,
        cast(0 as int64) as cntTechList,
        sum(Cost) / 1000 / 1000 * 30.0 as sumCost,
        0.0 as sumCostBlackList,
        0.0 as sumCostGrayList,
        0.0 as sumCostTechList,
        cast(count(distinct DomainID) as int64) as cntDomain
    from `//home/yabs/stat/BillingOrderDomains`
    where EventDate = $yesturday
    group by ServiceID
);

select 'cnt.' || sistem || "." || cast(ServiceID as string) || " " || cast(cnt as string) as val from $direct
union all
select 'cntBlackList.' || sistem || "." || cast(ServiceID as string) || " " || cast(cntBlackList as string) as val from $direct
union all
select 'cntGrayList.' || sistem || "." || cast(ServiceID as string) || " " || cast(cntGrayList as string) as val from $direct
union all
select 'cntTechList.' || sistem || "." || cast(ServiceID as string) || " " || cast(cntTechList as string) as val from $direct
union all
select 'sumCost.' || sistem || "." || cast(ServiceID as string) || " " || cast(sumCost as string) as val from $direct
union all
select 'sumCostBlackList.' || sistem || "." || cast(ServiceID as string) || " " || cast(sumCostBlackList as string) as val from $direct
union all
select 'sumCostGrayList.' || sistem || "." || cast(ServiceID as string) || " " || cast(sumCostGrayList as string) as val from $direct
union all
select 'sumCostTechList.' || sistem || "." || cast(ServiceID as string) || " " || cast(sumCostTechList as string) as val from $direct
'''

if __name__ == '__main__':
    yql_file = open(YQL_TOKEN)
    yql_token = yql_file.read()
    logFormat = u'[%(asctime)s pid: %(process)d. %(threadName)s] %(filename)s:%(lineno)d %(levelname)s: %(message)s'

    logging.basicConfig(level=logging.DEBUG, format=logFormat)

    nc = partial(netcat, graphite_host, graphite_port)
    tm = datetime.now().strftime("%s")

    for db in dbs:
        client = YqlClient(token=yql_token, db=db)
        request = client.query(QUERY,syntax_version=1)
        response = request.run()
        for table in response.get_results():
            table.fetch_full_data()
            for row in table.rows:
                try:
                    cells = [unicode(cell) for cell in row]
                    key_val = cells[0] # внутри YQL формируется вся строка с точкми и пробелами для value
                    #print key_val;
                    nc("{}.{}.{} {}".format(PREFIX, db, key_val, tm))
                except Exception as e:
                    print e
                    continue
