#!/usr/bin/env python
# -*- encoding: utf-8 -*-
"""
Скачивает необходимые для локального использования ключи из секретницы

"""

import os, json
import subprocess
import logging
import platform

logging.basicConfig(level=logging.INFO)

opt = {"stdout": subprocess.PIPE}
dir_name = ""

if platform.system() == "Windows":
    opt["shell"] = True
    dir_name = os.environ['HOMEPATH'] + '/.direct-tokens'
else:
    dir_name = os.environ['HOME'] + '/.direct-tokens'

get_secret_command = "ya vault get secret sec-01d2fwyjk5rz7zfz75axj2fnra -j"

if platform.system() == "Windows":
    process = subprocess.Popen(get_secret_command.split(), **opt)
else:
    process = subprocess.Popen(["/bin/bash", "-c", get_secret_command], **opt)
output, error = process.communicate()
if error: logging.error(error)

version = json.loads(output)['secret_versions'][0]['version']

get_version_command = "ya vault get version " + version + " -j"

if platform.system() == "Windows":
    process = subprocess.Popen(get_version_command.split(), **opt)
else:
    process = subprocess.Popen(["/bin/bash", "-c", get_version_command], **opt)
output, error = process.communicate()
if error: logging.error(error)

values = json.loads(output)['value']

if not os.path.exists(dir_name):
    os.mkdir(dir_name)

for k, v in values.items():
    file_name = k.split('.')[-1]
    try:
        with open(dir_name + '/' + file_name, "w") as f:
            f.write(v)
        logging.info(dir_name + '/' + file_name)
    except IOError as err:
        logging.error(err)
else:
    logging.info('OK')
