#!/bin/bash

set -e

# Скрипт для генерации unumов для фичей

ARCADIA_ROOT="${PWD}"
while [[ ! -e "${ARCADIA_ROOT}/.arcadia.root" ]]; do
    if [[ "${ARCADIA_ROOT}" == "/" ]]; then
        echo "$0: must be run from inside Arcadia checkout" >&2
        exit 1
    fi
    ARCADIA_ROOT="$(dirname "${ARCADIA_ROOT}")"
done

if [ -e $ARCADIA_ROOT/.svn ]; then
    vcs="svn"
    vcs_tool="$ARCADIA_ROOT/ya tool svn"
elif [ -e $ARCADIA_ROOT/.arc ]; then
    vcs="arc"
    vcs_tool="arc"
else
    echo "ARCADIA ROOT: $ARCADIA_ROOT is not under svn or arc vcs"
    exit 1
fi

TMP=`mktemp -d`
outdir="$TMP/out"

yaml_path="direct/libs-internal/base-model/src/main/resources/feature.yaml"
back_path="direct/libs-internal/base-model/src/main/java/ru/yandex/direct/feature/FeatureName.java"
front_path="adv/frontend/packages/direct-feature-flags/src/features.ts"
front_features_test_config="adv/frontend/packages/direct-feature-flags/src/featuresTestConfig.ts"

generator="direct/libs-internal/feature-generator"
generated="src/generated/java"

function compileit() {
    dir=$1
    echo "building $dir"
    $ARCADIA_ROOT/ya make --yt-store -q -o "$outdir" "$ARCADIA_ROOT/"$dir
    mv -f "$outdir/$dir/"*/*.jar $outdir
}

function clear() {
    rm -rf "$TMP"
}

compileit $generator


$ARCADIA_ROOT/ya tool java17 \
        -classpath "$outdir/*:" \
        ru.yandex.direct.feature.generator.FeatureGenerator \
        generate -c "$ARCADIA_ROOT/$yaml_path" -b "$ARCADIA_ROOT/$back_path" -f "$ARCADIA_ROOT/$front_path" -t "$ARCADIA_ROOT/$front_features_test_config"

echo "update file status in $vcs..."
if [ "$vcs" = "svn" ]; then
    ( cd "$ARCADIA_ROOT";
        $vcs_tool st {$back_path,$front_path,$front_features_test_config} > $TMP/status
        cat $TMP/status | awk '/^\?/ {print $2}' > $TMP/added
        cat $TMP/status | awk '/^!/ {print $2}' > $TMP/deleted
        test -s $TMP/added && cat $TMP/added | xargs $vcs_tool add
        test -s $TMP/deleted && cat $TMP/deleted | xargs $vcs_tool remove
        true
        )
elif [ "$vcs" = "arc" ]; then
    ( cd "$ARCADIA_ROOT";
        $vcs_tool add --all {$back_path,$front_path,$front_features_test_config}
        true
        )
else
    echo "wrong vcs"
    clear
    exit 1
fi

clear
