#!/bin/bash

set -e

# Скрипт для генерации моделй core-model, grid-core-model, grid-model, grid-processing и yt-components

ARCADIA_ROOT="${PWD}"
while [[ ! -e "${ARCADIA_ROOT}/.arcadia.root" ]]; do
    if [[ "${ARCADIA_ROOT}" == "/" ]]; then
        echo "$0: must be run from inside Arcadia checkout" >&2
        exit 1
    fi
    ARCADIA_ROOT="$(dirname "${ARCADIA_ROOT}")"
done

if [ -e $ARCADIA_ROOT/.hg ]; then
    vcs="hg"
    vcs_tool="$ARCADIA_ROOT/ya tool hg"
elif [ -e $ARCADIA_ROOT/.svn ]; then
    vcs="svn"
    vcs_tool="$ARCADIA_ROOT/ya tool svn"
elif [ -e $ARCADIA_ROOT/.arc ]; then
    vcs="arc"
    vcs_tool="$ARCADIA_ROOT/ya tool arc"
else
    echo "ARCADIA ROOT: $ARCADIA_ROOT is not under hg, svn or arc vcs"
    exit 1
fi

TMP=`mktemp -d`

model_conf="src/main/model-conf"
resources_model_conf="src/main/resources/model-conf"
generated="src/generated/java"

core_bidmodifier_model="direct/libs-internal/core-bidmodifier-model"
core_vcard_model="direct/libs-internal/core-vcard-model"
core_base_campaign_model="direct/libs-internal/core-base-campaign-model"
core_base_strategy_model="direct/libs-internal/core-base-strategy-model"
core_text_campaign_model="direct/libs-internal/core-text-campaign-model"
core_smart_campaign_model="direct/libs-internal/core-smart-campaign-model"
core_cpm_banner_campaign_model="direct/libs-internal/core-cpm-banner-campaign-model"
core_cpm_price_campaign_model="direct/libs-internal/core-cpm-price-campaign-model"
core_dynamic_campaign_model="direct/libs-internal/core-dynamic-campaign-model"
core_mobile_content_campaign_model="direct/libs-internal/core-mobile-content-campaign-model"
core_cpm_deals_campaign_model="direct/libs-internal/core-cpm-deals-campaign-model"
core_geo_campaign_model="direct/libs-internal/core-geo-campaign-model"
core_content_promotion_campaign_model="direct/libs-internal/core-content-promotion-campaign-model"
core_internal_autobudget_campaign_model="direct/libs-internal/core-internal-autobudget-campaign-model"
core_billing_aggregate_campaign_model="direct/libs-internal/core-billing-aggregate-campaign-model"
core_cpm_yndx_frontpage_campaign_model="direct/libs-internal/core-cpm-yndx-frontpage-campaign-model"
core_internal_distrib_campaign_model="direct/libs-internal/core-internal-distrib-campaign-model"
core_internal_free_campaign_model="direct/libs-internal/core-internal-free-campaign-model"
core_mcbanner_campaign_model="direct/libs-internal/core-mc-banner-campaign-model"
core_wallet_campaign_model="direct/libs-internal/core-wallet-campaign-model"
core_model="direct/libs-internal/core-model"
grid_model="direct/libs-internal/grid-model"
grid_core_model="direct/libs-internal/grid-core-model"
yt_components="direct/libs-internal/yt-components"
grid_processing="direct/libs-internal/grid-processing"
oneshot_core_models="direct/libs-internal/oneshot-core-model"
chassis_models="direct/libs-internal/chassis-model"
traceinterception_models="direct/libs-internal/traceinterception-model"
bstransport_internal_models="direct/libs-internal/bstransport"

model_generator="direct/libs/model-generator"

function doit() {
    dir=$1
    rewrite=$2
    echo "generating $dir..."
    models_conf="$ARCADIA_ROOT/$dir/src/main/model-conf"
    resources_model_conf="$ARCADIA_ROOT/$dir/src/main/resources/model-conf"
    if [ -e $models_conf ]; then
        models=$models_conf
    elif [ -e $resources_model_conf ]; then
        models=$resources_model_conf
    else
        echo "could not detect models forlder";
        exit 1
    fi
    $ARCADIA_ROOT/ya tool java17 \
        -classpath "$outdir/*:" \
        ru.yandex.direct.model.generator.Tool \
        "$models" -o "$outdir/gen" $rewrite -p ru.yandex.direct
    rm -rf "$ARCADIA_ROOT/$dir/$generated"
    mv "$outdir/gen" "$ARCADIA_ROOT/$dir/$generated"
}

function compileit() {
    dir=$1
    echo "building $dir"
    $ARCADIA_ROOT/ya make --yt-store -q -o "$outdir" "$ARCADIA_ROOT/"$dir
    mv -f "$outdir/"$dir/*.jar "$outdir"
}

function log-task-completion {
    local duration=$1
    local task='java.generate_models.time'

    local logging_url="https://intapi.direct.yandex.ru/metrics/add"

    curl -s -X POST \
        -H 'Content-Type: application/json' \
        -H 'Accept: application/json' \
        --max-time 2 \
        -d '{"metrics": [
                {"name":"'$task'", "value":'$duration', "context": {"login":"'$USER'", "platform": "'$(uname)'", "vcs": "'$vcs'"}}
           ]}' \
        $logging_url >/dev/null || echo "Warning: Can't send metrics"
}

start_time=$(date +%s)

echo "building model-generator..."
outdir="$TMP/out"
mkdir "$outdir"
$ARCADIA_ROOT/ya make --yt-store "$ARCADIA_ROOT/$model_generator" -q -o "$outdir"
mv "$outdir/$model_generator/"*/*.jar "$outdir"

doit $chassis_models --rewrite
compileit "direct/libs-internal/base-model" # нужен для генерации нескольких модулей
doit $core_bidmodifier_model --rewrite
compileit $core_bidmodifier_model
doit $core_vcard_model --rewrite
compileit $core_vcard_model
doit $core_base_campaign_model --rewrite
compileit $core_base_campaign_model 
doit $core_base_strategy_model --rewrite
doit $core_text_campaign_model --rewrite
doit $core_smart_campaign_model --rewrite
doit $core_cpm_banner_campaign_model --rewrite
doit $core_cpm_price_campaign_model --rewrite
doit $core_dynamic_campaign_model --rewrite
doit $core_mobile_content_campaign_model --rewrite
doit $core_cpm_deals_campaign_model --rewrite
doit $core_geo_campaign_model --rewrite
doit $core_content_promotion_campaign_model --rewrite
doit $core_internal_autobudget_campaign_model --rewrite
doit $core_billing_aggregate_campaign_model --rewrite
doit $core_cpm_yndx_frontpage_campaign_model --rewrite
doit $core_internal_distrib_campaign_model --rewrite
doit $core_internal_free_campaign_model --rewrite
doit $core_mcbanner_campaign_model --rewrite
doit $core_wallet_campaign_model --rewrite
doit $core_model --rewrite
compileit $core_model
doit $grid_model --rewrite
compileit $grid_model
compileit "direct/libs/i18n" # нужен для генерации grid-core-model (загрузка enum'а core в котором есть Translatable)
doit $grid_core_model --rewrite
compileit $grid_core_model
doit $yt_components --rewrite
doit $oneshot_core_models --rewrite
doit $traceinterception_models --rewrite
doit $grid_processing --rewrite
doit $bstransport_internal_models --rewrite

echo "update file status in $vcs..."
if [ "$vcs" = "hg" ]; then
    ( cd "$ARCADIA_ROOT";
        $vcs_tool st {$chassis_models,$core_bidmodifier_model,$core_vcard_model,$oneshot_core_models}/$generated >$TMP/status
        $vcs_tool st {$core_cpm_banner_campaign_model,$core_cpm_price_campaign_model,$core_dynamic_campaign_model,$core_mobile_content_campaign_model}/$generated >$TMP/status
        $vcs_tool st {$core_cpm_deals_campaign_model,$core_geo_campaign_model,$core_content_promotion_campaign_model,$core_internal_autobudget_campaign_model}/$generated >$TMP/status
        $vcs_tool st {$core_billing_aggregate_campaign_model,$core_cpm_yndx_frontpage_campaign_model,$core_internal_distrib_campaign_model,$core_internal_free_campaign_model,$core_mcbanner_campaign_model,$core_wallet_campaign_model}/$generated >$TMP/status
        $vcs_tool st {$core_base_campaign_model,$core_text_campaign_model,$core_smart_campaign_model,$core_model}/$generated >$TMP/status
        $vcs_tool st $core_base_strategy_model/$generated >$TMP/status
        $vcs_tool st {$grid_core_model,$grid_model,$yt_components,$grid_processing}/$generated >>$TMP/status
        $vcs_tool st {$traceinterception_models,$bstransport_internal_models}/$generated >>$TMP/status
        cat $TMP/status | awk '/^\?/ {print $2}' > $TMP/added
        cat $TMP/status | awk '/^!/ {print $2}' > $TMP/deleted
        test -s $TMP/added && cat $TMP/added | xargs $vcs_tool add
        test -s $TMP/deleted && cat $TMP/deleted | xargs $vcs_tool remove
        true
        )
elif [ "$vcs" = "svn" ]; then
    ( cd "$ARCADIA_ROOT";
        $vcs_tool st {$chassis_models,$core_bidmodifier_model,$core_vcard_model,$oneshot_core_models}/$generated >$TMP/status
        $vcs_tool st {$core_cpm_banner_campaign_model,$core_cpm_price_campaign_model,$core_dynamic_campaign_model,$core_mobile_content_campaign_model}/$generated >$TMP/status
        $vcs_tool st {$core_cpm_deals_campaign_model,$core_geo_campaign_model,$core_content_promotion_campaign_model,$core_internal_autobudget_campaign_model}/$generated >$TMP/status
        $vcs_tool st {$core_billing_aggregate_campaign_model,$core_cpm_yndx_frontpage_campaign_model,$core_internal_distrib_campaign_model,$core_internal_free_campaign_model,$core_mcbanner_campaign_model,$core_wallet_campaign_model}/$generated >$TMP/status
        $vcs_tool st {$core_base_campaign_model,$core_text_campaign_model,$core_smart_campaign_model,$core_model}/$generated >$TMP/status
        $vcs_tool st $core_base_strategy_model/$generated >$TMP/status
        $vcs_tool st {$grid_core_model,$grid_model,$yt_components,$grid_processing}/$generated >>$TMP/status
        $vcs_tool st {$traceinterception_models,$bstransport_internal_models}/$generated >>$TMP/status
        cat $TMP/status | awk '/^\?/ {print $2}' > $TMP/added
        cat $TMP/status | awk '/^!/ {print $2}' > $TMP/deleted
        test -s $TMP/added && cat $TMP/added | xargs $vcs_tool add
        test -s $TMP/deleted && cat $TMP/deleted | xargs $vcs_tool remove
        true
        )
elif [ "$vcs" = "arc" ]; then
    ( cd "$ARCADIA_ROOT";
        $vcs_tool add --all {$chassis_models,$core_bidmodifier_model,$core_vcard_model,$oneshot_core_models}/$generated
        $vcs_tool add --all {$core_cpm_banner_campaign_model,$core_cpm_price_campaign_model,$core_dynamic_campaign_model,$core_mobile_content_campaign_model}/$generated
        $vcs_tool add --all {$core_cpm_deals_campaign_model,$core_geo_campaign_model,$core_content_promotion_campaign_model,$core_internal_autobudget_campaign_model}/$generated
        $vcs_tool add --all {$core_billing_aggregate_campaign_model,$core_cpm_yndx_frontpage_campaign_model,$core_internal_distrib_campaign_model,$core_internal_free_campaign_model,$core_mcbanner_campaign_model,$core_wallet_campaign_model}/$generated
        $vcs_tool add --all {$core_base_campaign_model,$core_text_campaign_model,$core_smart_campaign_model,$core_model}/$generated
        $vcs_tool add --all $core_base_strategy_model/$generated
        $vcs_tool add --all {$grid_core_model,$grid_model,$yt_components,$grid_processing}/$generated
        $vcs_tool add --all {$traceinterception_models,$bstransport_internal_models}/$generated
        true
        )
else
    echo "wrong vcs"
    exit 1
fi

rm -rf "$TMP"

echo "send metrics..."
end_time=$(date +%s)
log-task-completion $((end_time-start_time))

