#!/bin/bash

set -e

ARCADIA_ROOT="$PWD"
while [[ ! -e "$ARCADIA_ROOT/.arcadia.root" ]]; do
    if [[ "$ARCADIA_ROOT" == "/" ]]; then
        echo "$0: must be run from inside Arcadia checkout" >&2
        exit 1
    fi
    ARCADIA_ROOT="$(dirname "$ARCADIA_ROOT")"
done

TMP=`mktemp -d`

OAUTH_GETTER_PATH=direct/infra/go-libs/cmd/oauth-token-getter

echo "Building $OAUTH_GETTER_PATH..."
"$ARCADIA_ROOT/ya" make --checkout --yt-store -q -o "$TMP" "$ARCADIA_ROOT/$OAUTH_GETTER_PATH"

GETTER="$TMP/$OAUTH_GETTER_PATH/oauth-token-getter"

function get_token {
    local out_file="$1"
    local cli_client_id="$2"
    local cli_client_secret="$3"

    local out_dir="$(dirname $out_file)"
    mkdir -p "$out_dir"
    chmod 0700 "$out_dir"

    echo "Getting token $out_file by ssh key..."
    "$GETTER" $cli_client_id $cli_client_secret >"$out_file.tmp"
    mv "$out_file.tmp" "$out_file"
    chmod 0400 "$out_file"

    echo "Done! Token file: $out_file"
}

# Oauth app with grants for Tracker
get_token \
    ~/.direct-tokens/local_user_oauth_token \
    7670b858973a48f18021e6a9f67b87b8 \
    359f54d69323441c8cd205be0f057592

# Oauth app with grants for YP
get_token \
    ~/.direct-tokens/local_user_oauth_token_yp \
    f8446f826a6f4fd581bf0636849fdcd7 \
    918d7af44bf74c53ace7fd94b7f3646c

# Oauth app with grants for Yav
get_token \
    ~/.direct-tokens/local_user_oauth_token_yav \
    ce68fbebc76c4ffda974049083729982 \
    b6cce2b79f784fa38033ff69f5061d53

# Oauth app with grants for Sandbox
# Should be same as https://sandbox.yandex-team.ru/oauth
get_token \
    ~/.direct-tokens/local_user_sandbox_token \
    b662b483feff40c1832e42cc1fcbc500 \
    5374b9cb258e4eed9903fd3a27c77b32

rm -rf "$TMP"
