#!/usr/bin/python
# -*- coding: utf-8 -*-

# Скрипт выполняет YQL запросы на кластерах HAHN/SENECA* для рассчета разной статистики
# по рекомендациям Директа, результаты работы запросов складывает в графит.
#
# Cкрипт запускается на 'ppcdev3' из крона
#*/30 * * * * /usr/bin/python /home/aliho/test/recom_yql_to_graphite.py >> /home/aliho/test/recom_yql_to_graphite.log

import os
import datetime
import json
import socket
import logging
import subprocess as sp

from yql.api.v1.client import YqlClient
#import statface_client

from functools import partial
from datetime import datetime
from calendar import timegm

PREFIX = 'junk.aliho.direct.recommendations'
YQL_TOKEN = '/etc/direct-tokens/yql_robot-direct-yt-test'

graphite_host = 'localhost' # 'ppcdev2.yandex.ru'
graphite_port = 42000 		# 7089

def netcat(hostname, port, content):
	s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
	s.connect((hostname, port))
	s.sendall(content)
	logging.info("Sent: %s", content)
	s.shutdown(socket.SHUT_WR)
	while 1:
		data = s.recv(1024)
		if data == "":
			break
		logging.info("Received: %s", repr(data))
	s.close()

dbs = ['senecasas', 'senecaman', 'senecamyt', 'senecavla', 'hahn']

QUERY_SENECA = u'''
$recom_table = "//home/direct/recommendations/current";
$yesturday = DateTime::ToSeconds(CurrentUtcDate() - Interval("P1D"));

$max_cnt_by_client = (
    select type, client_id, count(DISTINCT key) as cnt
    FROM (
        SELECT type, client_id,
            (
                "cid" || CAST(cid AS STRING) ||
                "pid" || CAST(pid AS STRING) ||
                "bid" || CAST(bid AS STRING)
            ) as key
        from $recom_table
        where `timestamp` > $yesturday
    ) as a
    group by type, client_id
);

select 'daily.count.type.max.' || cast(type as string) || ' ' || cast(max(cnt) as string) as val from $max_cnt_by_client group by type
union all
select 'daily.count.type.' || cast(type as string) || ' ' || cast(count(*) as string) as val from $recom_table
where `timestamp` > $yesturday group by type
union all
select 'daily.count.type.client.' || cast(type as string) || ' ' || cast(count(distinct client_id) as string) as val from $recom_table
where `timestamp` > $yesturday group by type
union all
select "daily.maxtime.maxtimestamp " || Unwrap(cast(max(`timestamp`) as string)) as val from $recom_table
union all
select "daily.mintime.mintimestamp " || Unwrap(cast(min(`timestamp`) as string)) as val from $recom_table
union all
select 'daily.count.recommendations.status.' || cast(status as string) || ' ' || cast(count(*) as string) as val from `//home/direct/mysql-sync/current/combined/recommendations_status`
group by status;
'''

QUERY_HAHN = '''
$date_format = DateTime::Format("%Y-%m-%d");

$today = $date_format(CurrentUtcDatetime() - Interval("P0DT3H"));
$recom_log = "//home/direct/logs/recommendations";
$my_table = $recom_log || "/" || $today;
SELECT 'execution.clients.count.type.' || cast(type as string) || ' ' || cast(count(DISTINCT ClientID) as string) as val
FROM $my_table
WHERE status = 'DONE'
GROUP BY type
UNION ALL
SELECT 'execution.count.type.' || cast(type as string) || '.' || cast(status as string) || ' ' || cast(count(*) as string) as val
FROM $my_table
GROUP BY type, status;
'''

if __name__ == '__main__':
	yql_file = open(YQL_TOKEN)
	yql_token = yql_file.read()
	logFormat = u'[%(asctime)s pid: %(process)d. %(threadName)s] %(filename)s:%(lineno)d %(levelname)s: %(message)s'

	logging.basicConfig(level=logging.DEBUG, format=logFormat)

	nc = partial(netcat, graphite_host, graphite_port)
	tm = datetime.now().strftime("%s")

	for db in dbs:
		client = YqlClient(token=yql_token, db=db)
		if db == 'hahn':
			request = client.query(QUERY_HAHN,syntax_version=1)
		else:
			request = client.query(QUERY_SENECA,syntax_version=1)
		response = request.run()
		for table in response.get_results():
			table.fetch_full_data()
			for row in table.rows:
				try:
					cells = [unicode(cell) for cell in row]
					val = cells[0]
					nc("{}.{}.{} {}".format(PREFIX, db, val, tm))
				except Exception as e:
					print e
					continue

