#!/bin/bash


# Перед запуском локально нужно получить токен в интранет (запись и чтение вики, чтение staff)
# токен читается из ~/.intranet_token
# https://wiki.yandex-team.ru/intranet/dev/oauth/
set -e

CMD=${1?Usage: $0 [-l head_login] (список логинов через запятую, выгрузка будет для всех участников групп этих логинов) \-p users/login/report/ (путь вики страницы) \[-d дата]}
# shift
DIRECT_DIR=`dirname $0`/../
APP_DIR=$DIRECT_DIR/apps/maintenance-helpers
JAVA=$APP_DIR/jdk/bin/java
LOGIN=`whoami`

INTRANET_TOKEN=~/.intranet_token
STRATREK_TOKEN=~/.startrek_token

mkdir ~/tmp || true

if [ ! -f "$INTRANET_TOKEN" ];
then
    echo "Please create token file $INTRANET_TOKEN https://wiki.yandex-team.ru/intranet/dev/oauth/"
    echo 'Add rw for wiki and r staff permissions'
    echo 'Or use my clientid https://oauth.yandex-team.ru/authorize?response_type=token&client_id=1e5c3701d7e243ce8f4603c44df5ec61'
    exit
fi

if [ ! -f "$STRATREK_TOKEN" ];
then
    echo "Please create startrek token file $STRATREK_TOKEN https://oauth.yandex-team.ru/authorize?response_type=token&client_id=5f671d781aca402ab7460fde4050267b"
    exit
fi

ya make "$APP_DIR" >&2

function run_export() {
    $JAVA \
        -classpath "$APP_DIR/maintenance-helpers/*:" \
        ru.yandex.direct.reports.TaskResultsReport \
        $@
}

run_export $@

exit
