#!/bin/bash


# Описание URL-ов и получения токена https://clubs.at.yandex-team.ru/tanker/729
# Ссылка на получение токена https://oauth.yandex-team.ru/authorize?response_type=token&client_id=bbb4cb8bfac744afbeb539375be80a72 или https://nda.ya.ru/3SjQY7
# Токен кладем в  ~/.ssh/tanker-direct-java-token
set -e

CMD=${1?Usage: $0 [download|upload|sandbox_upload ya_path -t token|sandbox_download ya_path -t token] [--debug]?}
shift
DIRECT_DIR=`dirname $0`/../
APP_DIR=$DIRECT_DIR/apps/direct-tanker-tool
JAVA=$APP_DIR/jdk/bin/java

if [[ "$CMD" =~ sandbox* ]]; then
    YA=$1
    shift
else
    ya make "$APP_DIR" >&2
fi

FLAGS=$@

function tanker_tool_sandbox() {
    $JAVA \
        -classpath "$APP_DIR/direct-tanker-tool/*:" \
        ru.yandex.direct.apps.tanker.tool.DirectTankerTool \
        $FLAGS \
        $@
}

function tanker_tool() {
    $JAVA \
        -classpath "$APP_DIR/direct-tanker-tool/*:" \
        ru.yandex.direct.apps.tanker.tool.DirectTankerTool \
        -f ~/.ssh/tanker-direct-java-token \
        $FLAGS \
        $@
}

function doit() {
    package=$1
    dir=$2
    if [ "$CMD" == "upload" ]; then
        tanker_tool --package-prefix "$package" upload
    elif [ "$CMD" == "download" ]; then
        tanker_tool --package-prefix "$package" download --target-dir "$dir"
        for file in `ya tool svn st "$dir"|awk '/^\?/ {print $2}'`; do
            ya tool svn add "$file"
        done
    elif [ "$CMD" == "sandbox_upload" ]; then
        tanker_tool_sandbox --package-prefix "$package" upload
    elif [ "$CMD" == "sandbox_download" ]; then
        tanker_tool_sandbox --package-prefix "$package" download --target-dir "$dir"
        for file in `$YA tool svn st "$dir"|awk '/^\?/ {print $2}'`; do
            $YA tool svn add "$file"
        done
    else
        echo Unsupported command $CMD
        exit 1
    fi
}

doit ru.yandex.direct.api.v5 $DIRECT_DIR/api5/src/main/resources/locale/
doit ru.yandex.direct.core $DIRECT_DIR/core/src/main/resources/locale/
doit ru.yandex.direct.common $DIRECT_DIR/common/src/main/resources/locale/
doit ru.yandex.direct.intapi $DIRECT_DIR/intapi/src/main/resources/locale/
doit ru.yandex.direct.jobs $DIRECT_DIR/jobs/src/main/resources/locale/
doit ru.yandex.direct.web $DIRECT_DIR/web/src/main/resources/locale/
doit ru.yandex.direct.currency $DIRECT_DIR/libs/currency/src/main/resources/locale/
doit ru.yandex.direct.libs.graphql $DIRECT_DIR/libs-internal/graphql/src/main/resources/locale/
doit ru.yandex.direct.feature $DIRECT_DIR/libs-internal/base-model/src/main/resources/locale/
doit ru.yandex.direct.grid.processing $DIRECT_DIR/libs-internal/grid-processing/src/main/resources/locale/

CRYPTA_FLAGS="-p crypta download --single-keyset profile --single-filename-prefix CryptaGoalTranslations --target-dir $DIRECT_DIR/core/src/main/resources/locale/ru/yandex/direct/core/entity/crypta/"

if [ "$CMD" == "download" ]; then
    tanker_tool $CRYPTA_FLAGS
elif [ "$CMD" == "sandbox_download" ]; then
    tanker_tool_sandbox $CRYPTA_FLAGS
fi

exit
