package ru.yandex.canvas;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.configs.CanvasTvmConfiguration;
import ru.yandex.canvas.configs.MongoCustomConversionsConfig;
import ru.yandex.canvas.configs.RequestLoggingFilterConfig;
import ru.yandex.canvas.configs.ServiceConfig;
import ru.yandex.canvas.configs.WebConfig;
import ru.yandex.canvas.configs.WebMvcConfig;
import ru.yandex.direct.jcommander.ParserWithHelp;
import ru.yandex.direct.logging.LoggingInitializer;
import ru.yandex.direct.logging.LoggingInitializerParams;


@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class})
@RestController
@EnableRetry
@Import({
        ServiceConfig.class,
        WebConfig.class,
        MongoCustomConversionsConfig.class,
        WebMvcConfig.class,
        RequestLoggingFilterConfig.class,
        CanvasTvmConfiguration.class
})
public class Application {
    public static void main(String[] args) {
        LoggingInitializerParams loggingParams = new LoggingInitializerParams();
        ParserWithHelp.parse(Application.class.getCanonicalName(), args, loggingParams);
        LoggingInitializer.initialize(loggingParams, "direct.canvas");

        SpringApplication.run(Application.class, args);
    }
}
