package ru.yandex.canvas;

import java.io.IOException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.canvas.model.HtmlCharacterEscapes;

public class JSONObjectHelper {
    public static final Logger logger = LoggerFactory.getLogger(JSONObjectHelper.class);
    private ObjectNode root;

    public JSONObjectHelper() throws IOException {
        root = JsonNodeFactory.instance.objectNode();
    }

    private ObjectNode getRoot() {
        return root;
    }

    public JSONObjectHelper add(String name, JSONObjectHelper helper) throws IOException {
        root.set(name, helper.getRoot());
        return this;
    }

    public JSONObjectHelper add(String name, String value) throws IOException {
        root.put(name, value);
        return this;
    }

    public JSONObjectHelper add(String name, long value) throws IOException {
        root.put(name, value);
        return this;
    }

    public JSONObjectHelper add(String name, Object value) throws IOException {
        root.putPOJO(name, value);
        return this;
    }

    public JSONObjectHelper addIf(Supplier<Boolean> predicate, String name, JSONObjectHelper helper)
            throws IOException {
        if (predicate.get()) {
            return add(name, helper);
        }

        return this;
    }

    public JSONObjectHelper addIf(Supplier<Boolean> predicate, String name, Object value) throws IOException {
        if (predicate.get()) {
            return add(name, value);
        }

        return this;
    }

    public JSONObjectHelper addif(Supplier<Boolean> predicate, String name, String value) throws IOException {
        if (predicate.get()) {
            return add(name, value);
        }

        return this;
    }

    public JSONObjectHelper addIf(Supplier<Boolean> predicate, String name, long value) throws IOException {
        if (predicate.get()) {
            return add(name, value);
        }

        return this;
    }

    public <T> JSONObjectHelper addStream(Stream<T> stream, Function<T, String> getKey, Function<T, String> getValue) {

        stream.forEach(e -> {
            try {
                add(getKey.apply(e), getValue.apply(e));
            } catch (IOException e1) {
                logger.warn("Exception while processing stream", e);
            }
        });

        return this;
    }

    public String toJSON() throws IOException {

        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.getFactory().setCharacterEscapes(new HtmlCharacterEscapes());
        //objectMapper.getFactory().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);

        return objectMapper.writeValueAsString(root);
    }

}
