package ru.yandex.canvas;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonValue;

public class TimeDelta {
    private long seconds;

    public TimeDelta(long seconds) {
        if (seconds < 0 || seconds >= 3600) {
            throw new IllegalArgumentException("time delta must be great or equal to zero and less than 1 hour: " + seconds);
        }

        this.seconds = seconds;
    }

    public TimeDelta(double seconds) {
        this((long) Math.ceil(seconds));
    }

    @JsonValue
    @Override
    public String toString() {
        //736         return "00:{:02d}:{:02d}".format((secs // 60) % 60, secs % 60)
        return String.format("00:%02d:%02d", seconds / 60, seconds % 60);
    }

    public double asSeconds() {
        return (double) seconds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TimeDelta timeDelta = (TimeDelta) o;
        return seconds == timeDelta.seconds;
    }

    @Override
    public int hashCode() {
        return Objects.hash(seconds);
    }
}
