package ru.yandex.canvas;

import java.util.List;
import java.util.Set;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

import ru.yandex.canvas.service.video.AdParams;
import ru.yandex.canvas.service.video.VideoCreativeType;
import ru.yandex.canvas.service.video.presets.PresetTag;

public class VideoConstants {
    public static final List<String> GOOD_COLORS =
            ImmutableList.of("#ffdc00", "#ff0000", "#ffffff", "#fb3e00", "#008bff");
    public static final String INTERACTIVE_VPAID_PCODE_URL =
            "https://yastatic.net/awaps-ad-sdk-js/1_0/interactive_viewer.js";
    public static final String VIDEO_MOTION_VPAID_PCODE_URL = INTERACTIVE_VPAID_PCODE_URL;
    public static final String INTERACTIVE_VPAID_THEME = "video-banner_interactive-viewer";

    public static final String DEFAULT_VPAID_PCODE_URL = "https://yastatic.net/pcode/media/vpaid-creative.js";
    public static final String EMPTY_THEME_CREATIVE_VPAID_PCODE_URL =
            "https://yastatic.net/awaps-ad-sdk-js/1_0/vpaid-creative.js";
    public static final String VIDEO_EMPTY_THEME = "video-banner_theme_empty";
    public static final String VIDEO_SURVEY_THEME = "video-banner_survey";
    public static final String VIDEO_SURVEY_PCODE_URL = "https://yastatic.net/pcode/media/vpaid-pythia-survey-embed.js";

    public static final String AUDIO_CREATIVE_PREVIEW_URL =//Для аудиорекламы заглушка
            "https://avatars.mds.yandex.net/get-direct/1524269/MUOVWKq6UGHT1glNpY_wiw/orig";

    public static final long VIDEO_MOTION_CREATIVE_ID = 777;
    public static final String VIDEO_MOTION_THEME = "video-banner_motion";
    public static final long VIDEO_MOTION_SKIP_OFFSET = 5;
    public static final long VIDEO_MOTION_DURATION = 15;

    //a fancy thumbnail from https://st.yandex-team.ru/CANVAS-475
    public static final String DEFAULT_THUMBNAIL_URL =
            "https://storage.mds.yandex.net/get-bstor/15200/0c846b62-84e4-4fa0-8838-cd2d90753e7f.txt";

    public static final String VIDEO_AD_SYSTEM_DEFAULT = "Yabs Ad Server";
    public static final String VIDEO_AD_SYSTEM_CPC = "Yabs Ad CPC Server";

    public static final String PACKSHOT_START_NOTICE_URL = AdParams.RTB_HOST_TRACKING_URL_MACRO + "?action-id=10";

    public static final Set<String> KNOWN_MIME_TYPES = ImmutableSet.of("image/jpeg", "image/gif", "image/png");

    public static final int IMAGE_HEIGHT_MIN = 1080;
    public static final int IMAGE_HEIGHT_MAX = 3840;
    public static final int IMAGE_WIDTH_MIN = 1080;
    public static final int IMAGE_WIDTH_MAX = 3840;

    public static final int IMAGE_CPM_AUDIO_HEIGHT_MAX = 900;
    public static final int IMAGE_CPM_AUDIO_HEIGHT_MIN = 900;
    public static final int IMAGE_CPM_AUDIO_WIDTH_MAX = 900;
    public static final int IMAGE_CPM_AUDIO_WIDTH_MIN = 900;

    public static final String CANVAS_VIDEO_ANY_SIZE_ALLOWED_FEATURE = "canvas_video_any_size_allowed";
    public static final String CANVAS_RANGE_RATIO_FEATURE = "canvas_range_ratio";
    public static final String CANVAS_RANGE_RATIO_CPC_FEATURE = "canvas_range_ratio_cpc";
    public static final String CANVAS_CMS_ENCODE_FEATURE = "canvas_cms_encode";
    public static final String CANVAS_ASYNC_VIDEO_CREATIVE_CREATION_FEATURE = "canvas_async_video_creative_creation";
    public static final String NEW_LIVE_PREVIEW_URL_FOR_VIDEO_CREATIVES_ENABLED_FEATURE =
            "new_live_preview_url_for_video_creatives_enabled";
    public static final String NEW_SCREENSHOT_URL_FOR_VIDEO_CREATIVES_ENABLED_FEATURE =
            "new_screenshot_url_for_video_creatives_enabled";
    public static final String SUBTITLES_FOR_VIDEO_CREATIVES_ENABLED_FEATURE = "subtitles_for_video_creatives_enabled";


    public static final Set<VideoCreativeType> CANVAS_RANGE_RATIO_CPC_FEATURE_ALLOWED_CREATIVE_TYPES =
            ImmutableSet.of(VideoCreativeType.TEXT, VideoCreativeType.MOBILE_CONTENT, VideoCreativeType.CPC,
                    VideoCreativeType.MOBILE_CONTENT_VIDEO);
    public static final Set<PresetTag> CANVAS_RANGE_RATIO_CPC_FEATURE_TAGS = Set.of(PresetTag.CPC, PresetTag.COMMON,
            PresetTag.MOBILE_CONTENT, PresetTag.MOBILE_CONTENT_VIDEO);

    public static final Set<Long> UNWANTED_PRESET_IDS = ImmutableSet.of(1L, 2L, 4L,11L,12L,14L,16L,17L,25L,
            28L,45L,48L,51L,52L,54L,61L,62L,64L,66L,67L);

    //Максимальное количество конвертируемых файлов на клиента. Если больше, то не разрешаем загрузить.
    //Рейт лимитер нужен чтобы не задедосить нас. Выключается клиенту фичей skip_video_file_rate_limit
    public static final long VIDEO_FILE_RATE_LIMIT = 40;
}
