package ru.yandex.canvas.configs;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.CommonsRequestLoggingFilter;

@ParametersAreNonnullByDefault
public class CanvasRequestLoggingFilter extends CommonsRequestLoggingFilter {
    private static final String LOGGER_NAME = "CANVAS_REQUESTS.log";
    private static final Logger logger = LoggerFactory.getLogger(LOGGER_NAME);

    @Override
    protected boolean shouldLog(HttpServletRequest request) {
        return true;
    }

    @Override
    protected void beforeRequest(HttpServletRequest request, String message) {
        // не логируем перед запросом, все будет залогировано после
    }

    @Override
    protected void afterRequest(HttpServletRequest request, String message) {
        String output = "method=" + request.getMethod() + ";uri=" +
                request.getRequestURI();
        if (isIncludeQueryString()) {
            output += "?" + request.getQueryString();
        }
        if (isIncludePayload()) {
            boolean binaryData = request.getHeader("Content-Type") != null && request.getHeader("Content-Type")
                    .startsWith("multipart/form-data");

            String body = "<binary data>";
            if (!binaryData) {
                body = getMessagePayload(request);
            }
            output += ";payload=" + body;

        }
        logger.info(output);
    }
}
