package ru.yandex.canvas.configs;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.canvas.exceptions.AuthException;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.tvm.AbstractTvmInterceptor;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;

/**
 * Реализация {@link AbstractTvmInterceptor}
 */
public class CanvasTvmInterceptor extends AbstractTvmInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CanvasTvmInterceptor.class);

    public CanvasTvmInterceptor(TvmIntegration tvmIntegration, EnvironmentType environmentType) {
        super(tvmIntegration, environmentType);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Exception accessDeniedExceptionInvalidTvmTicket(Exception cause) {
        return new AuthException("Invalid tvm service ticket: " + cause);
    }

    @Override
    protected Exception accessDeniedExceptionInvalidUserTicket(Exception cause) {
        return new AuthException("Invalid user ticket: " + cause);
    }

    @Override
    protected Exception accessDeniedExceptionNoTvmTicket() {
        return new AuthException("Missing TVM ticked");
    }

    @Override
    protected Exception sourceApplicationAccessDeniedException(TvmService sourceService) {
        return new AuthException(String.format("Access denied for tvm service %s", sourceService));
    }
}
