package ru.yandex.canvas.configs;

import java.text.MessageFormat;
import java.util.Map;
import java.util.UUID;

import javax.servlet.RequestDispatcher;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.WebRequest;

import ru.yandex.canvas.service.scraper.ScraperException;

import static ru.yandex.canvas.service.TankerKeySet.ERROR;

/**
 * Overrides unexpected exception message
 * to return something user-readable
 * instead of stacktrace.
 * Also injects a GUID into the message and logs them both
 * in order to enable searching the reason of exception.
 */
public class MessageOverridingErrorAttributes extends DefaultErrorAttributes {

    private static final Logger logger = LoggerFactory.getLogger(MessageOverridingErrorAttributes.class);


    @Override
    public Map<String, Object> getErrorAttributes(
            WebRequest webRequest,
            boolean includeStackTrace) {
        final Map<String, Object> errorAttributes = super.getErrorAttributes(webRequest, includeStackTrace);
        final Integer statusCode = (Integer) webRequest
                .getAttribute(RequestDispatcher.ERROR_STATUS_CODE, RequestAttributes.SCOPE_REQUEST);
        if (statusCode != null && HttpStatus.valueOf(statusCode).is5xxServerError()) {
            final String uuid = UUID.randomUUID().toString();
            final Throwable exception = getError(webRequest);
            String msg = uuid;
            if (exception instanceof ScraperException) {
                msg += ", system info: " + ((ScraperException) exception).getSystemInfo();
            }
            logger.error(msg, exception);
            errorAttributes.put("requestId", uuid);
            errorAttributes.put("message", MessageFormat.format(ERROR.key("internal-server-error"), uuid));
        }
        return errorAttributes;
    }
}
