package ru.yandex.canvas.configs;


import org.springframework.context.annotation.Configuration;

import ru.yandex.direct.solomon.SolomonUtils;
import ru.yandex.direct.version.DirectVersion;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;

import static ru.yandex.direct.solomon.SolomonUtils.SOLOMON_REGISTRY;

/**
 * Отправка метрик о работе приложения в graphite
 */
@Configuration
public class MetricsConfiguration {

    public MetricsConfiguration() {
        SolomonUtils.addJvmMetrics();

        SOLOMON_REGISTRY.lazyCounter("sensors_total", SOLOMON_REGISTRY::estimateCount);

        GaugeInt64 major = SOLOMON_REGISTRY.gaugeInt64("major_version");
        major.set(DirectVersion.getMajorVersion());

        GaugeInt64 minor = SOLOMON_REGISTRY.gaugeInt64("minor_version");
        minor.set(DirectVersion.getMinorVersion());
    }

}


