package ru.yandex.canvas.configs;

import java.util.Date;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

import ru.yandex.direct.tracing.TraceHelper;
import ru.yandex.direct.tracing.TraceLogger;

@Configuration
@Order
public class TracingConfiguration {
    @Bean(name = "taskScheduler")
    TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("TracingBackgroundT-");
        scheduler.setDaemon(true);
        scheduler.setRemoveOnCancelPolicy(true);
        return scheduler;
    }

    @Bean
    TraceLogger traceLogger(@Qualifier("taskScheduler") TaskScheduler scheduler) {
        return new TraceLogger((command, period, unit) -> scheduler.scheduleWithFixedDelay(
                command,
                new Date(System.currentTimeMillis() + unit.toMillis(period)),
                unit.toMillis(period)
        ));
    }

    @Bean
    public TraceHelper traceHelper(@Value("${tracing.service_name}") String tracingServiceName, TraceLogger traceLogger) {
        return new TraceHelper(tracingServiceName, traceLogger);
    }
}
